/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.login;

import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.browserid.JSONWebTokenUtils;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.login.BaseRequestDelegate;
import org.mozilla.gecko.fxa.login.FxAccountLoginStateMachine;
import org.mozilla.gecko.fxa.login.FxAccountLoginTransition;
import org.mozilla.gecko.fxa.login.Married;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.login.TokensAndKeysState;
import org.mozilla.gecko.sync.ExtendedJSONObject;

public class Cohabiting
extends TokensAndKeysState {
    private static final String LOG_TAG = Cohabiting.class.getSimpleName();

    public Cohabiting(String string2, String string3, byte[] byArray, byte[] byArray2, byte[] byArray3, BrowserIDKeyPair browserIDKeyPair) {
        super(State.StateLabel.Cohabiting, string2, string3, byArray, byArray2, byArray3, browserIDKeyPair);
    }

    @Override
    public void execute(FxAccountLoginStateMachine.ExecuteDelegate executeDelegate) {
        executeDelegate.getClient().sign(this.sessionToken, this.keyPair.getPublic().toJSONObject(), executeDelegate.getCertificateDurationInMilliseconds(), (FxAccountClient10.RequestDelegate<String>)new BaseRequestDelegate<String>((State)this, executeDelegate){

            @Override
            public void handleSuccess(String string2) {
                if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                    try {
                        FxAccountConstants.pii(LOG_TAG, "Fetched certificate: " + string2);
                        ExtendedJSONObject extendedJSONObject = JSONWebTokenUtils.parseCertificate(string2);
                        if (extendedJSONObject != null) {
                            FxAccountConstants.pii(LOG_TAG, "Header   : " + extendedJSONObject.getObject("header"));
                            FxAccountConstants.pii(LOG_TAG, "Payload  : " + extendedJSONObject.getObject("payload"));
                            FxAccountConstants.pii(LOG_TAG, "Signature: " + extendedJSONObject.getString("signature"));
                        } else {
                            FxAccountConstants.pii(LOG_TAG, "Could not parse certificate!");
                        }
                    }
                    catch (Exception exception) {
                        FxAccountConstants.pii(LOG_TAG, "Could not parse certificate!");
                    }
                }
                this.delegate.handleTransition(new FxAccountLoginTransition.LogMessage("sign succeeded"), new Married(Cohabiting.this.email, Cohabiting.this.uid, Cohabiting.this.sessionToken, Cohabiting.this.kA, Cohabiting.this.kB, Cohabiting.this.keyPair, string2));
            }
        });
    }
}

