/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.gfx.IntSize;
import org.mozilla.gecko.util.FloatUtils;

public final class RectUtils {
    private RectUtils() {
    }

    public static Rect create(JSONObject jSONObject) {
        try {
            int n = jSONObject.getInt("x");
            int n2 = jSONObject.getInt("y");
            int n3 = jSONObject.getInt("width");
            int n4 = jSONObject.getInt("height");
            return new Rect(n, n2, n + n3, n2 + n4);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    public static String toJSON(RectF rectF) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("{ \"left\": ").append(rectF.left).append(", \"top\": ").append(rectF.top).append(", \"right\": ").append(rectF.right).append(", \"bottom\": ").append(rectF.bottom).append('}');
        return stringBuilder.toString();
    }

    public static RectF expand(RectF rectF, float f, float f2) {
        float f3 = f / 2.0f;
        float f4 = f2 / 2.0f;
        return new RectF(rectF.left - f3, rectF.top - f4, rectF.right + f3, rectF.bottom + f4);
    }

    public static RectF contract(RectF rectF, float f, float f2) {
        float f3 = f / 2.0f;
        float f4 = f2 / 2.0f;
        return new RectF(rectF.left + f3, rectF.top + f4, rectF.right - f3, rectF.bottom - f4);
    }

    public static RectF intersect(RectF rectF, RectF rectF2) {
        float f = Math.max(rectF.left, rectF2.left);
        float f2 = Math.max(rectF.top, rectF2.top);
        float f3 = Math.min(rectF.right, rectF2.right);
        float f4 = Math.min(rectF.bottom, rectF2.bottom);
        return new RectF(f, f2, Math.max(f3, f), Math.max(f4, f2));
    }

    public static RectF scale(RectF rectF, float f) {
        float f2 = rectF.left * f;
        float f3 = rectF.top * f;
        return new RectF(f2, f3, f2 + rectF.width() * f, f3 + rectF.height() * f);
    }

    public static RectF scaleAndRound(RectF rectF, float f) {
        float f2 = rectF.left * f;
        float f3 = rectF.top * f;
        return new RectF((float)Math.round(f2), (float)Math.round(f3), (float)Math.round(f2 + rectF.width() * f), (float)Math.round(f3 + rectF.height() * f));
    }

    public static Rect round(RectF rectF) {
        Rect rect = new Rect();
        RectUtils.round(rectF, rect);
        return rect;
    }

    public static void round(RectF rectF, Rect rect) {
        rect.set(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    public static Rect roundIn(RectF rectF) {
        return new Rect((int)Math.ceil(rectF.left), (int)Math.ceil(rectF.top), (int)Math.floor(rectF.right), (int)Math.floor(rectF.bottom));
    }

    public static IntSize getSize(Rect rect) {
        return new IntSize(rect.width(), rect.height());
    }

    public static Point getOrigin(Rect rect) {
        return new Point(rect.left, rect.top);
    }

    public static PointF getOrigin(RectF rectF) {
        return new PointF(rectF.left, rectF.top);
    }

    public static boolean fuzzyEquals(RectF rectF, RectF rectF2) {
        if (rectF == null && rectF2 == null) {
            return true;
        }
        if (rectF == null && rectF2 != null || rectF != null && rectF2 == null) {
            return false;
        }
        return FloatUtils.fuzzyEquals((float)rectF.top, (float)rectF2.top) && FloatUtils.fuzzyEquals((float)rectF.left, (float)rectF2.left) && FloatUtils.fuzzyEquals((float)rectF.right, (float)rectF2.right) && FloatUtils.fuzzyEquals((float)rectF.bottom, (float)rectF2.bottom);
    }
}

