/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.PointF;
import android.os.Handler;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.util.GeckoEventListener;

class SubdocumentScrollHelper
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoSubdocScroll";
    private static final String MESSAGE_PANNING_OVERRIDE = "Panning:Override";
    private static final String MESSAGE_CANCEL_OVERRIDE = "Panning:CancelOverride";
    private static final String MESSAGE_SCROLL = "Gesture:Scroll";
    private static final String MESSAGE_SCROLL_ACK = "Gesture:ScrollAck";
    private final Handler mUiHandler = new Handler();
    private final EventDispatcher mEventDispatcher;
    private final PointF mPendingDisplacement = new PointF();
    private boolean mOverridePanning;
    private boolean mOverrideScrollAck;
    private boolean mOverrideScrollPending;
    private boolean mScrollSucceeded;

    SubdocumentScrollHelper(EventDispatcher eventDispatcher) {
        this.mEventDispatcher = eventDispatcher;
        this.mEventDispatcher.registerGeckoThreadListener(this, MESSAGE_PANNING_OVERRIDE, MESSAGE_CANCEL_OVERRIDE, MESSAGE_SCROLL_ACK);
    }

    void destroy() {
        this.mEventDispatcher.unregisterGeckoThreadListener(this, MESSAGE_PANNING_OVERRIDE, MESSAGE_CANCEL_OVERRIDE, MESSAGE_SCROLL_ACK);
    }

    boolean scrollBy(PointF pointF) {
        if (!this.mOverridePanning) {
            return false;
        }
        if (!this.mOverrideScrollAck) {
            this.mOverrideScrollPending = true;
            this.mPendingDisplacement.x += pointF.x;
            this.mPendingDisplacement.y += pointF.y;
            return true;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("x", (double)pointF.x);
            jSONObject.put("y", (double)pointF.y);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error forming subwindow scroll message: ", (Throwable)jSONException);
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent(MESSAGE_SCROLL, jSONObject.toString()));
        this.mOverrideScrollAck = false;
        this.mOverrideScrollPending = false;
        this.mPendingDisplacement.x = 0.0f;
        this.mPendingDisplacement.y = 0.0f;
        return true;
    }

    void cancel() {
        this.mOverridePanning = false;
    }

    boolean scrolling() {
        return this.mOverridePanning;
    }

    boolean lastScrollSucceeded() {
        return this.mScrollSucceeded;
    }

    public void handleMessage(final String string2, final JSONObject jSONObject) {
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SubdocumentScrollHelper.MESSAGE_PANNING_OVERRIDE.equals(string2)) {
                        SubdocumentScrollHelper.this.mOverridePanning = true;
                        SubdocumentScrollHelper.this.mOverrideScrollAck = true;
                        SubdocumentScrollHelper.this.mOverrideScrollPending = false;
                        SubdocumentScrollHelper.this.mScrollSucceeded = true;
                    } else if (SubdocumentScrollHelper.MESSAGE_CANCEL_OVERRIDE.equals(string2)) {
                        SubdocumentScrollHelper.this.mOverridePanning = false;
                    } else if (SubdocumentScrollHelper.MESSAGE_SCROLL_ACK.equals(string2)) {
                        SubdocumentScrollHelper.this.mOverrideScrollAck = true;
                        SubdocumentScrollHelper.this.mScrollSucceeded = jSONObject.getBoolean("scrolled");
                        if (SubdocumentScrollHelper.this.mOverridePanning && SubdocumentScrollHelper.this.mOverrideScrollPending) {
                            SubdocumentScrollHelper.this.scrollBy(SubdocumentScrollHelper.this.mPendingDisplacement);
                        }
                    }
                }
                catch (Exception exception) {
                    Log.e((String)SubdocumentScrollHelper.LOGTAG, (String)"Exception handling message", (Throwable)exception);
                }
            }
        });
    }
}

