/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.content.Context;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import java.util.LinkedList;
import java.util.Queue;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.gfx.JavaPanZoomController;
import org.mozilla.gecko.gfx.SimpleScaleGestureDetector;

final class TouchEventHandler
implements Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "GeckoTouchEventHandler";
    private final int EVENT_LISTENER_TIMEOUT = 200;
    private final View mView;
    private final GestureDetector mGestureDetector;
    private final SimpleScaleGestureDetector mScaleGestureDetector;
    private final JavaPanZoomController mPanZoomController;
    private final Queue<MotionEvent> mEventQueue;
    private final ListenerTimeoutProcessor mListenerTimeoutProcessor;
    private boolean mWaitForTouchListeners;
    private boolean mHoldInQueue;
    private boolean mAllowDefaultAction;
    private int mProcessingBalance;

    TouchEventHandler(Context context, View view, JavaPanZoomController javaPanZoomController) {
        this.mView = view;
        this.mEventQueue = new LinkedList<MotionEvent>();
        this.mPanZoomController = javaPanZoomController;
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.mPanZoomController);
        this.mScaleGestureDetector = new SimpleScaleGestureDetector(this.mPanZoomController);
        this.mListenerTimeoutProcessor = new ListenerTimeoutProcessor();
        this.mAllowDefaultAction = true;
        this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)this.mPanZoomController);
        Tabs.registerOnTabsChangedListener(this);
    }

    public void destroy() {
        Tabs.unregisterOnTabsChangedListener(this);
    }

    public boolean handleEvent(MotionEvent motionEvent) {
        if (this.isDownEvent(motionEvent)) {
            this.mHoldInQueue = this.mWaitForTouchListeners;
            this.mAllowDefaultAction = true;
            if (this.mHoldInQueue) {
                if (this.mEventQueue.isEmpty()) {
                    this.mPanZoomController.startingNewEventBlock(motionEvent, true);
                }
            } else {
                this.mEventQueue.add(null);
                this.mPanZoomController.startingNewEventBlock(motionEvent, false);
            }
            this.mView.postDelayed((Runnable)this.mListenerTimeoutProcessor, 200L);
        }
        if (this.mHoldInQueue) {
            this.mEventQueue.add(MotionEvent.obtain((MotionEvent)motionEvent));
        } else {
            this.dispatchEvent(motionEvent, this.mAllowDefaultAction);
        }
        return false;
    }

    public void handleEventListenerAction(boolean bl) {
        if (this.mProcessingBalance <= 0) {
            this.processEventBlock(bl);
        }
        --this.mProcessingBalance;
    }

    public void setWaitForTouchListeners(boolean bl) {
        this.mWaitForTouchListeners = bl;
    }

    private boolean isDownEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction() & 0xFF;
        return n == 0 || n == 5;
    }

    private boolean touchFinished(MotionEvent motionEvent) {
        int n = motionEvent.getAction() & 0xFF;
        return n == 1 || n == 3;
    }

    private void dispatchEvent(MotionEvent motionEvent, boolean bl) {
        if (bl) {
            if (this.mGestureDetector.onTouchEvent(motionEvent)) {
                return;
            }
            this.mScaleGestureDetector.onTouchEvent(motionEvent);
            if (this.mScaleGestureDetector.isInProgress()) {
                return;
            }
        }
        this.mPanZoomController.handleEvent(motionEvent, !bl);
    }

    private void processEventBlock(boolean bl) {
        if (this.mEventQueue.isEmpty()) {
            Log.e((String)LOGTAG, (String)"Unexpected empty event queue in processEventBlock!", (Throwable)new Exception());
            return;
        }
        MotionEvent motionEvent = this.mEventQueue.poll();
        while (true) {
            if (motionEvent != null) {
                this.dispatchEvent(motionEvent, bl);
                motionEvent.recycle();
                motionEvent = null;
            }
            if (this.mEventQueue.isEmpty()) {
                this.mHoldInQueue = false;
                this.mAllowDefaultAction = bl;
                break;
            }
            motionEvent = this.mEventQueue.peek();
            if (motionEvent == null || this.isDownEvent(motionEvent)) {
                if (motionEvent == null) break;
                this.mPanZoomController.startingNewEventBlock(motionEvent, true);
                break;
            }
            this.mEventQueue.remove();
        }
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        if (Tabs.getInstance().isSelectedTab(tab) && tabEvents == Tabs.TabEvents.STOP || tabEvents == Tabs.TabEvents.SELECTED) {
            this.mWaitForTouchListeners = tab.getHasTouchListeners();
        }
    }

    private class ListenerTimeoutProcessor
    implements Runnable {
        private ListenerTimeoutProcessor() {
        }

        @Override
        public void run() {
            if (TouchEventHandler.this.mProcessingBalance >= 0) {
                TouchEventHandler.this.processEventBlock(true);
            }
            TouchEventHandler.this.mProcessingBalance++;
        }
    }
}

