/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.HorizontalScrollView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.TabMenuStripLayout;

public class TabMenuStrip
extends HorizontalScrollView
implements HomePager.Decor {
    private static final int TITLE_OFFSET_DIPS = 24;
    private final int titleOffset;
    private final TabMenuStripLayout layout;
    private final Paint shadowPaint;
    private final int shadowSize;

    public TabMenuStrip(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setHorizontalScrollBarEnabled(false);
        Resources resources = this.getResources();
        this.titleOffset = (int)(24.0f * resources.getDisplayMetrics().density);
        this.layout = new TabMenuStripLayout(context, attributeSet);
        this.addView((View)this.layout, -1, -1);
        this.shadowSize = resources.getDimensionPixelSize(R.dimen.tabs_strip_shadow_size);
        this.shadowPaint = new Paint();
        this.shadowPaint.setColor(resources.getColor(R.color.url_bar_shadow));
        this.shadowPaint.setStrokeWidth(0.0f);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        int n = this.getHeight();
        canvas.drawRect(0.0f, (float)(n - this.shadowSize), (float)this.getWidth(), (float)n, this.shadowPaint);
    }

    @Override
    public void onAddPagerView(String string2) {
        this.layout.onAddPagerView(string2);
    }

    @Override
    public void removeAllPagerViews() {
        this.layout.removeAllViews();
    }

    @Override
    public void onPageSelected(int n) {
        this.layout.onPageSelected(n);
    }

    @Override
    public void onPageScrolled(int n, float f, int n2) {
        int n3;
        this.layout.onPageScrolled(n, f, n2);
        View view = this.layout.getChildAt(n);
        if (view == null) {
            return;
        }
        int n4 = (int)(f * (float)view.getWidth());
        int n5 = view.getLeft() + n4;
        if (n > 0) {
            n5 -= this.titleOffset;
        }
        int n6 = view.getRight() + n4;
        if (n < this.layout.getChildCount() - 1) {
            n6 += this.titleOffset;
        }
        if (n5 < (n3 = this.getScrollX())) {
            this.scrollTo(n5, 0);
        } else if (n6 > n3 + this.getWidth()) {
            this.scrollTo(n6 - this.getWidth(), 0);
        }
    }

    @Override
    public void setOnTitleClickListener(HomePager.OnTitleClickListener onTitleClickListener) {
        this.layout.setOnTitleClickListener(onTitleClickListener);
    }
}

