/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.overlays.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.mozilla.gecko.R;

public class OverlayDialogButton
extends LinearLayout {
    private static final String LOGTAG = "GeckoOverlayDialogButton";
    private ImageView icon;
    private TextView label;
    private String enabledLabel;
    private Drawable enabledIcon;
    private String disabledLabel;
    private Drawable disabledIcon;
    private View.OnClickListener enabledOnClickListener;
    private View.OnClickListener disabledOnClickListener;
    private boolean isEnabled = true;

    public OverlayDialogButton(Context context) {
        super(context);
        this.init(context);
    }

    public OverlayDialogButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public OverlayDialogButton(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    private void init(Context context) {
        this.setOrientation(0);
        this.setPadding(0, 0, 0, 0);
        this.setBackgroundResource(R.drawable.overlay_share_button_background);
        LayoutInflater.from((Context)context).inflate(R.layout.overlay_share_button, (ViewGroup)this);
        this.icon = (ImageView)this.findViewById(R.id.overlaybtn_icon);
        this.label = (TextView)this.findViewById(R.id.overlaybtn_label);
    }

    public void setEnabledLabelAndIcon(String string2, Drawable drawable2) {
        this.enabledLabel = string2;
        this.enabledIcon = drawable2;
        if (this.isEnabled) {
            this.updateViews();
        }
    }

    public void setDisabledLabelAndIcon(String string2, Drawable drawable2) {
        this.disabledLabel = string2;
        this.disabledIcon = drawable2;
        if (!this.isEnabled) {
            this.updateViews();
        }
    }

    private void updateViews() {
        this.label.setEnabled(this.isEnabled);
        if (this.isEnabled) {
            this.label.setText((CharSequence)this.enabledLabel);
            this.icon.setImageDrawable(this.enabledIcon);
            super.setOnClickListener(this.enabledOnClickListener);
        } else {
            this.label.setText((CharSequence)this.disabledLabel);
            this.icon.setImageDrawable(this.disabledIcon);
            super.setOnClickListener(this.getPopListener());
        }
    }

    private View.OnClickListener getPopListener() {
        if (this.disabledOnClickListener == null) {
            this.disabledOnClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    Animation animation = AnimationUtils.loadAnimation((Context)OverlayDialogButton.this.getContext(), (int)R.anim.overlay_pop);
                    OverlayDialogButton.this.icon.startAnimation(animation);
                }
            };
        }
        return this.disabledOnClickListener;
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.enabledOnClickListener = onClickListener;
        if (this.isEnabled) {
            this.updateViews();
        }
    }

    public void setEnabled(boolean bl) {
        if (bl == this.isEnabled) {
            return;
        }
        this.isEnabled = bl;
        this.updateViews();
    }
}

