/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.Context;
import android.preference.PreferenceCategory;
import android.util.AttributeSet;
import org.mozilla.gecko.preferences.CustomListPreference;

public abstract class CustomListCategory
extends PreferenceCategory {
    protected CustomListPreference mDefaultReference;

    public CustomListCategory(Context context) {
        super(context);
    }

    public CustomListCategory(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public CustomListCategory(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    protected void onAttachedToActivity() {
        super.onAttachedToActivity();
        this.setOrderingAsAdded(true);
    }

    protected void setFallbackDefault() {
        if (this.getPreferenceCount() > 0) {
            CustomListPreference customListPreference = (CustomListPreference)this.getPreference(0);
            this.setDefault(customListPreference);
        }
    }

    public void uninstall(CustomListPreference customListPreference) {
        this.removePreference(customListPreference);
        if (customListPreference == this.mDefaultReference) {
            this.setFallbackDefault();
        }
    }

    public void setDefault(CustomListPreference customListPreference) {
        if (this.mDefaultReference != null) {
            this.mDefaultReference.setIsDefault(false);
        }
        customListPreference.setIsDefault(true);
        this.mDefaultReference = customListPreference;
    }
}

