/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.crypto;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.crypto.CryptoException;
import org.mozilla.gecko.sync.crypto.HKDF;

public class KeyBundle {
    private static final String KEY_ALGORITHM_SPEC = "AES";
    private static final int KEY_SIZE = 256;
    private byte[] encryptionKey;
    private byte[] hmacKey;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final byte[] ENCR_INPUT_BYTES = new byte[]{1};
    private static final byte[] HMAC_INPUT_BYTES = new byte[]{2};

    public KeyBundle(String string2, String string3) throws CryptoException {
        Mac mac;
        if (string3 == null) {
            throw new IllegalArgumentException("No sync key provided.");
        }
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("No username provided.");
        }
        try {
            string2 = Utils.usernameFromAccount(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("Invalid username.");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Invalid username.");
        }
        byte[] byArray = Utils.decodeFriendlyBase32(string3);
        byte[] byArray2 = string2.getBytes();
        try {
            mac = HKDF.makeHMACHasher(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CryptoException(invalidKeyException);
        }
        assert (mac != null);
        byte[] byArray3 = Utils.concatAll(EMPTY_BYTES, HKDF.HMAC_INPUT, byArray2, ENCR_INPUT_BYTES);
        byte[] byArray4 = HKDF.digestBytes(byArray3, mac);
        byte[] byArray5 = Utils.concatAll(byArray4, HKDF.HMAC_INPUT, byArray2, HMAC_INPUT_BYTES);
        this.hmacKey = HKDF.digestBytes(byArray5, mac);
        this.encryptionKey = byArray4;
    }

    public KeyBundle(byte[] byArray, byte[] byArray2) {
        this.setEncryptionKey(byArray);
        this.setHMACKey(byArray2);
    }

    public static KeyBundle fromBase64EncodedKeys(String string2, String string3) throws UnsupportedEncodingException {
        return new KeyBundle(Base64.decodeBase64((byte[])string2.getBytes("UTF-8")), Base64.decodeBase64((byte[])string3.getBytes("UTF-8")));
    }

    public static KeyBundle withRandomKeys() throws CryptoException {
        KeyGenerator keyGenerator;
        try {
            keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM_SPEC);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoException(noSuchAlgorithmException);
        }
        keyGenerator.init(256);
        byte[] byArray = keyGenerator.generateKey().getEncoded();
        byte[] byArray2 = keyGenerator.generateKey().getEncoded();
        return new KeyBundle(byArray, byArray2);
    }

    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(byte[] byArray) {
        this.encryptionKey = byArray;
    }

    public byte[] getHMACKey() {
        return this.hmacKey;
    }

    public void setHMACKey(byte[] byArray) {
        this.hmacKey = byArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeyBundle)) {
            return false;
        }
        KeyBundle keyBundle = (KeyBundle)object;
        return Arrays.equals(keyBundle.encryptionKey, this.encryptionKey) && Arrays.equals(keyBundle.hmacKey, this.hmacKey);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("No hashCode for KeyBundle.");
    }
}

