/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.jpake;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.crypto.HKDF;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.jpake.BigIntegerHelper;
import org.mozilla.gecko.sync.jpake.Gx3OrGx4IsZeroOrOneException;
import org.mozilla.gecko.sync.jpake.IncorrectZkpException;
import org.mozilla.gecko.sync.jpake.JPakeNumGenerator;
import org.mozilla.gecko.sync.jpake.JPakeParty;
import org.mozilla.gecko.sync.jpake.Zkp;

public class JPakeCrypto {
    private static final String LOG_TAG = "JPakeCrypto";
    public static final BigInteger P = new BigInteger("90066455B5CFC38F9CAA4A48B4281F292C260FEEF01FD61037E56258A7795A1C7AD46076982CE6BB956936C6AB4DCFE05E6784586940CA544B9B2140E1EB523F009D20A7E7880E4E5BFA690F1B9004A27811CD9904AF70420EEFD6EA11EF7DA129F58835FF56B89FAA637BC9AC2EFAAB903402229F491D8D3485261CD068699B6BA58A1DDBBEF6DB51E8FE34E8A78E542D7BA351C21EA8D8F1D29F5D5D15939487E27F4416B0CA632C59EFD1B1EB66511A5A0FBF615B766C5862D0BD8A3FE7A0E0DA0FB2FE1FCB19E8F9996A8EA0FCCDE538175238FC8B0EE6F29AF7F642773EBE8CD5402415A01451A840476B2FCEB0E388D30D4B376C37FE401C2A2C2F941DAD179C540C1C8CE030D460C4D983BE9AB0B20F69144C1AE13F9383EA1C08504FB0BF321503EFE43488310DD8DC77EC5B8349B8BFE97C2C560EA878DE87C11E3D597F1FEA742D73EEC7F37BE43949EF1A0D15C3F3E3FC0A8335617055AC91328EC22B50FC15B941D3D1624CD88BC25F3E941FDDC6200689581BFEC416B4B2CB73", 16);
    public static final BigInteger Q = new BigInteger("CFA0478A54717B08CE64805B76E5B14249A77A4838469DF7F7DC987EFCCFB11D", 16);
    public static final BigInteger G = new BigInteger("5E5CBA992E0A680D885EB903AEA78E4A45A469103D448EDE3B7ACCC54D521E37F84A4BDD5B06B0970CC2D2BBB715F7B82846F9A0C393914C792E6A923E2117AB805276A975AADB5261D91673EA9AAFFEECBFA6183DFCB5D3B7332AA19275AFA1F8EC0B60FB6F66CC23AE4870791D5982AAD1AA9485FD8F4A60126FEB2CF05DB8A7F0F09B3397F3937F2E90B9E5B9C9B6EFEF642BC48351C46FB171B9BFA9EF17A961CE96C7E7A7CC3D3D03DFAD1078BA21DA425198F07D2481622BCE45969D9C4D6063D72AB7A0F08B2F49A7CC6AF335E08C4720E31476B67299E231F8BD90B39AC3AE3BE0C6B6CACEF8289A2E2873D58E51E029CAFBD55E6841489AB66B5B4B9BA6E2F784660896AFF387D92844CCB8B69475496DE19DA2E58259B090489AC8E62363CDF82CFD8EF2A427ABCD65750B506F56DDE3B988567A88126B914D7828E2B63A6D7ED0747EC59E0E0A23CE7D8A74C1D2C2A7AFB6A29799620F00E11C33787F7DED3B30E1A22D09F1FBDA1ABBBFBF25CAE05A13F812E34563F99410E73B", 16);

    public static void round1(JPakeParty jPakeParty, JPakeNumGenerator jPakeNumGenerator) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        BigInteger bigInteger = jPakeNumGenerator.generateFromRange(Q);
        BigInteger bigInteger2 = jPakeParty.x2 = BigInteger.ONE.add(jPakeNumGenerator.generateFromRange(Q.subtract(BigInteger.ONE)));
        BigInteger bigInteger3 = G.modPow(bigInteger, P);
        BigInteger bigInteger4 = G.modPow(bigInteger2, P);
        jPakeParty.gx1 = bigInteger3;
        jPakeParty.gx2 = bigInteger4;
        jPakeParty.zkp1 = JPakeCrypto.createZkp(G, bigInteger, bigInteger3, jPakeParty.signerId, jPakeNumGenerator);
        jPakeParty.zkp2 = JPakeCrypto.createZkp(G, bigInteger2, bigInteger4, jPakeParty.signerId, jPakeNumGenerator);
    }

    public static void round2(BigInteger bigInteger, JPakeParty jPakeParty, JPakeNumGenerator jPakeNumGenerator) throws IncorrectZkpException, NoSuchAlgorithmException, Gx3OrGx4IsZeroOrOneException, UnsupportedEncodingException {
        Logger.debug(LOG_TAG, "round2 started.");
        if (BigInteger.ZERO.compareTo(jPakeParty.gx3) == 0 || BigInteger.ONE.compareTo(jPakeParty.gx3) == 0 || BigInteger.ZERO.compareTo(jPakeParty.gx4) == 0 || BigInteger.ONE.compareTo(jPakeParty.gx4) == 0) {
            throw new Gx3OrGx4IsZeroOrOneException();
        }
        JPakeCrypto.checkZkp(G, jPakeParty.gx3, jPakeParty.zkp3);
        JPakeCrypto.checkZkp(G, jPakeParty.gx4, jPakeParty.zkp4);
        BigInteger bigInteger2 = jPakeParty.gx3.multiply(jPakeParty.gx4).mod(P).multiply(jPakeParty.gx1).mod(P);
        BigInteger bigInteger3 = jPakeParty.x2.multiply(bigInteger).mod(P);
        BigInteger bigInteger4 = bigInteger2.modPow(bigInteger3, P);
        jPakeParty.thisZkpA = JPakeCrypto.createZkp(bigInteger2, bigInteger3, bigInteger4, jPakeParty.signerId, jPakeNumGenerator);
        jPakeParty.thisA = bigInteger4;
        Logger.debug(LOG_TAG, "round2 finished.");
    }

    public static KeyBundle finalRound(BigInteger bigInteger, JPakeParty jPakeParty) throws IncorrectZkpException, NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        Logger.debug(LOG_TAG, "Final round started.");
        BigInteger bigInteger2 = jPakeParty.gx1.multiply(jPakeParty.gx2).mod(P).multiply(jPakeParty.gx3).mod(P);
        JPakeCrypto.checkZkp(bigInteger2, jPakeParty.otherA, jPakeParty.otherZkpA);
        BigInteger bigInteger3 = jPakeParty.gx4.modPow(jPakeParty.x2.multiply(bigInteger).negate().mod(Q), P).multiply(jPakeParty.otherA).modPow(jPakeParty.x2, P);
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[32];
        JPakeCrypto.generateKeyAndHmac(bigInteger3, byArray, byArray2);
        Logger.debug(LOG_TAG, "Final round finished; returning key.");
        return new KeyBundle(byArray, byArray2);
    }

    private static byte[] HMACSHA256(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "HmacSHA256");
            mac.init(secretKeySpec);
            byArray3 = mac.doFinal(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            Logger.error(LOG_TAG, "Got exception calculating HMAC.", generalSecurityException);
        }
        return byArray3;
    }

    private static Zkp createZkp(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, String string2, JPakeNumGenerator jPakeNumGenerator) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        BigInteger bigInteger4 = jPakeNumGenerator.generateFromRange(Q);
        BigInteger bigInteger5 = bigInteger.modPow(bigInteger4, P);
        BigInteger bigInteger6 = JPakeCrypto.computeBHash(bigInteger, bigInteger5, bigInteger3, string2);
        Logger.debug(LOG_TAG, "myhash: " + bigInteger6.toString(16));
        BigInteger bigInteger7 = bigInteger4.subtract(bigInteger2.multiply(bigInteger6)).mod(Q);
        return new Zkp(bigInteger5, bigInteger7, string2);
    }

    private static void checkZkp(BigInteger bigInteger, BigInteger bigInteger2, Zkp zkp) throws IncorrectZkpException, NoSuchAlgorithmException, UnsupportedEncodingException {
        BigInteger bigInteger3 = JPakeCrypto.computeBHash(bigInteger, zkp.gr, bigInteger2, zkp.id);
        if (bigInteger2.compareTo(BigInteger.ONE) < 1) {
            Logger.error(LOG_TAG, "g^x > 1 fails.");
            throw new IncorrectZkpException();
        }
        if (bigInteger2.compareTo(P.subtract(BigInteger.ONE)) > -1) {
            Logger.error(LOG_TAG, "g^x < p-1 fails.");
            throw new IncorrectZkpException();
        }
        if (bigInteger2.modPow(Q, P).compareTo(BigInteger.ONE) != 0) {
            Logger.error(LOG_TAG, "g^x^q % p = 1 fails.");
            throw new IncorrectZkpException();
        }
        if (zkp.gr.compareTo(bigInteger.modPow(zkp.b, P).multiply(bigInteger2.modPow(bigInteger3, P)).mod(P)) != 0) {
            Logger.debug(LOG_TAG, "gb*g(xh) = " + bigInteger.modPow(zkp.b, P).multiply(bigInteger2.modPow(bigInteger3, P)).mod(P).toString(16));
            Logger.debug(LOG_TAG, "gr = " + zkp.gr.toString(16));
            Logger.debug(LOG_TAG, "b = " + zkp.b.toString(16));
            Logger.debug(LOG_TAG, "g^b = " + bigInteger.modPow(zkp.b, P).toString(16));
            Logger.debug(LOG_TAG, "g^(xh) = " + bigInteger2.modPow(bigInteger3, P).toString(16));
            Logger.debug(LOG_TAG, "gx = " + bigInteger2.toString(16));
            Logger.debug(LOG_TAG, "h = " + bigInteger3.toString(16));
            Logger.error(LOG_TAG, "zkp calculation incorrect.");
            throw new IncorrectZkpException();
        }
        Logger.debug(LOG_TAG, "*** ZKP SUCCESS ***");
    }

    private static BigInteger computeBHash(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, String string2) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.reset();
        JPakeCrypto.hashByteArrayWithLength(messageDigest, BigIntegerHelper.BigIntegerToByteArrayWithoutSign(bigInteger));
        JPakeCrypto.hashByteArrayWithLength(messageDigest, BigIntegerHelper.BigIntegerToByteArrayWithoutSign(bigInteger2));
        JPakeCrypto.hashByteArrayWithLength(messageDigest, BigIntegerHelper.BigIntegerToByteArrayWithoutSign(bigInteger3));
        JPakeCrypto.hashByteArrayWithLength(messageDigest, string2.getBytes("UTF-8"));
        byte[] byArray = messageDigest.digest();
        return BigIntegerHelper.ByteArrayToBigIntegerWithoutSign(byArray);
    }

    private static void hashByteArrayWithLength(MessageDigest messageDigest, byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[]{(byte)(n >>> 8), (byte)(n & 0xFF)};
        messageDigest.update(byArray2);
        messageDigest.update(byArray);
    }

    public static void generateKeyAndHmac(BigInteger bigInteger, byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = JPakeCrypto.HMACSHA256(BigIntegerHelper.BigIntegerToByteArrayWithoutSign(bigInteger), byArray3);
        byte[] byArray5 = HKDF.hkdfExpand(byArray4, HKDF.HMAC_INPUT, 64);
        System.arraycopy(byArray5, 0, byArray, 0, 32);
        System.arraycopy(byArray5, 32, byArray2, 0, 32);
    }
}

