/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.stage;

import android.content.Context;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.json.simple.parser.ParseException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.EngineSettings;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.MetaGlobalException;
import org.mozilla.gecko.sync.NoCollectionKeysSetException;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.SynchronizerConfiguration;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.delegates.WipeServerDelegate;
import org.mozilla.gecko.sync.middleware.Crypto5MiddlewareRepository;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.SyncStorageRequest;
import org.mozilla.gecko.sync.net.SyncStorageRequestDelegate;
import org.mozilla.gecko.sync.net.SyncStorageResponse;
import org.mozilla.gecko.sync.repositories.InactiveSessionException;
import org.mozilla.gecko.sync.repositories.InvalidSessionTransitionException;
import org.mozilla.gecko.sync.repositories.RecordFactory;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.RepositorySession;
import org.mozilla.gecko.sync.repositories.RepositorySessionBundle;
import org.mozilla.gecko.sync.repositories.Server11Repository;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionBeginDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionCreationDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFinishDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionWipeDelegate;
import org.mozilla.gecko.sync.stage.AbstractSessionManagingSyncStage;
import org.mozilla.gecko.sync.stage.NoSuchStageException;
import org.mozilla.gecko.sync.synchronizer.ServerLocalSynchronizer;
import org.mozilla.gecko.sync.synchronizer.Synchronizer;
import org.mozilla.gecko.sync.synchronizer.SynchronizerDelegate;
import org.mozilla.gecko.sync.synchronizer.SynchronizerSession;

public abstract class ServerSyncStage
extends AbstractSessionManagingSyncStage
implements SynchronizerDelegate {
    protected static final String LOG_TAG = "ServerSyncStage";
    protected long stageStartTimestamp = -1L;
    protected long stageCompleteTimestamp = -1L;

    protected boolean isEnabled() throws MetaGlobalException {
        EngineSettings engineSettings = null;
        try {
            engineSettings = this.getEngineSettings();
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Unable to get engine settings for " + this + ": fetching config failed.", exception);
        }
        boolean bl = this.session.isEngineRemotelyEnabled(this.getEngineName(), engineSettings);
        this.checkAndUpdateUserSelectedEngines(bl);
        if (!bl) {
            Logger.debug(LOG_TAG, "Stage " + this.getEngineName() + " disabled by server meta/global.");
            return false;
        }
        boolean bl2 = this.session.isEngineLocallyEnabled(this.getEngineName());
        if (!bl2) {
            Logger.debug(LOG_TAG, "Stage " + this.getEngineName() + " disabled just for this sync.");
        }
        return bl2;
    }

    protected void checkAndUpdateUserSelectedEngines(boolean bl) throws MetaGlobalException {
        boolean bl2;
        Map<String, Boolean> map = this.session.config.userSelectedEngines;
        String string2 = this.getEngineName();
        if (map != null && map.containsKey(string2) && bl != (bl2 = map.get(string2).booleanValue())) {
            Logger.debug(LOG_TAG, "Engine state has been changed by user. Throwing exception.");
            throw new MetaGlobalException.MetaGlobalEngineStateChangedException(bl2);
        }
    }

    protected EngineSettings getEngineSettings() throws NonObjectJSONException, IOException, ParseException {
        SynchronizerConfiguration synchronizerConfiguration;
        Integer n = this.getStorageVersion();
        if (n == null) {
            Logger.warn(LOG_TAG, "null storage version for " + this + "; using version 0.");
            n = 0;
        }
        if ((synchronizerConfiguration = this.getConfig()) == null) {
            return new EngineSettings(null, n);
        }
        return new EngineSettings(synchronizerConfiguration.syncID, n);
    }

    protected abstract String getCollection();

    protected abstract String getEngineName();

    protected abstract Repository getLocalRepository();

    protected abstract RecordFactory getRecordFactory();

    protected Repository getRemoteRepository() throws URISyntaxException {
        String string2 = this.getCollection();
        return new Server11Repository(string2, this.session.config.storageURL(), this.session.getAuthHeaderProvider(), this.session.config.infoCollections);
    }

    protected Repository wrappedServerRepo() throws NoCollectionKeysSetException, URISyntaxException {
        String string2 = this.getCollection();
        KeyBundle keyBundle = this.session.keyBundleForCollection(string2);
        Crypto5MiddlewareRepository crypto5MiddlewareRepository = new Crypto5MiddlewareRepository(this.getRemoteRepository(), keyBundle);
        crypto5MiddlewareRepository.recordFactory = this.getRecordFactory();
        return crypto5MiddlewareRepository;
    }

    protected String bundlePrefix() {
        return this.getCollection() + ".";
    }

    protected SynchronizerConfiguration getConfig() throws NonObjectJSONException, IOException, ParseException {
        return new SynchronizerConfiguration(this.session.config.getBranch(this.bundlePrefix()));
    }

    protected void persistConfig(SynchronizerConfiguration synchronizerConfiguration) {
        synchronizerConfiguration.persist(this.session.config.getBranch(this.bundlePrefix()));
    }

    public Synchronizer getConfiguredSynchronizer(GlobalSession globalSession) throws NoCollectionKeysSetException, URISyntaxException, NonObjectJSONException, IOException, ParseException {
        Repository repository = this.wrappedServerRepo();
        ServerLocalSynchronizer serverLocalSynchronizer = new ServerLocalSynchronizer();
        serverLocalSynchronizer.repositoryA = repository;
        serverLocalSynchronizer.repositoryB = this.getLocalRepository();
        serverLocalSynchronizer.load(this.getConfig());
        return serverLocalSynchronizer;
    }

    @Override
    protected void resetLocal() {
        this.resetLocalWithSyncID(null);
    }

    protected void resetLocalWithSyncID(String string2) {
        SynchronizerConfiguration synchronizerConfiguration;
        try {
            synchronizerConfiguration = this.getConfig();
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Unable to reset " + this + ": fetching config failed.", exception);
            return;
        }
        if (string2 != null) {
            synchronizerConfiguration.syncID = string2;
            Logger.info(LOG_TAG, "Setting syncID for " + this + " to '" + string2 + "'.");
        }
        synchronizerConfiguration.localBundle.setTimestamp(0L);
        synchronizerConfiguration.remoteBundle.setTimestamp(0L);
        this.persistConfig(synchronizerConfiguration);
        Logger.info(LOG_TAG, "Reset timestamps for " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void wipeLocal() throws Exception {
        this.resetLocal();
        final WipeWaiter wipeWaiter = new WipeWaiter();
        final Context context = this.session.getContext();
        final Repository repository = this.getLocalRepository();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                repository.createSession(new RepositorySessionCreationDelegate(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onSessionCreated(final RepositorySession repositorySession) {
                        try {
                            repositorySession.begin(new RepositorySessionBeginDelegate(){

                                @Override
                                public void onBeginSucceeded(final RepositorySession repositorySession2) {
                                    repositorySession2.wipe(new RepositorySessionWipeDelegate(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void onWipeSucceeded() {
                                            try {
                                                repositorySession2.finish(new RepositorySessionFinishDelegate(){

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     */
                                                    @Override
                                                    public void onFinishSucceeded(RepositorySession repositorySession, RepositorySessionBundle repositorySessionBundle) {
                                                        WipeWaiter wipeWaiter = wipeWaiter;
                                                        synchronized (wipeWaiter) {
                                                            wipeWaiter.notify();
                                                        }
                                                    }

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     */
                                                    @Override
                                                    public void onFinishFailed(Exception exception) {
                                                        WipeWaiter wipeWaiter = wipeWaiter;
                                                        synchronized (wipeWaiter) {
                                                            wipeWaiter.notify(exception, true);
                                                        }
                                                    }

                                                    @Override
                                                    public RepositorySessionFinishDelegate deferredFinishDelegate(ExecutorService executorService) {
                                                        return this;
                                                    }
                                                });
                                            }
                                            catch (InactiveSessionException inactiveSessionException) {
                                                WipeWaiter wipeWaiter = wipeWaiter;
                                                synchronized (wipeWaiter) {
                                                    wipeWaiter.notify(inactiveSessionException, true);
                                                }
                                            }
                                        }

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void onWipeFailed(Exception exception) {
                                            repositorySession2.abort();
                                            WipeWaiter wipeWaiter = wipeWaiter;
                                            synchronized (wipeWaiter) {
                                                wipeWaiter.notify(exception, true);
                                            }
                                        }

                                        @Override
                                        public RepositorySessionWipeDelegate deferredWipeDelegate(ExecutorService executorService) {
                                            return this;
                                        }
                                    });
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void onBeginFailed(Exception exception) {
                                    repositorySession.abort();
                                    WipeWaiter wipeWaiter = wipeWaiter;
                                    synchronized (wipeWaiter) {
                                        wipeWaiter.notify(exception, true);
                                    }
                                }

                                @Override
                                public RepositorySessionBeginDelegate deferredBeginDelegate(ExecutorService executorService) {
                                    return this;
                                }
                            });
                        }
                        catch (InvalidSessionTransitionException invalidSessionTransitionException) {
                            repositorySession.abort();
                            WipeWaiter wipeWaiter = wipeWaiter;
                            synchronized (wipeWaiter) {
                                wipeWaiter.notify(invalidSessionTransitionException, true);
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onSessionCreateFailed(Exception exception) {
                        WipeWaiter wipeWaiter = wipeWaiter;
                        synchronized (wipeWaiter) {
                            wipeWaiter.notify(exception, false);
                        }
                    }

                    @Override
                    public RepositorySessionCreationDelegate deferredCreationDelegate() {
                        return this;
                    }
                }, context);
            }
        };
        Thread thread = new Thread(runnable);
        WipeWaiter wipeWaiter2 = wipeWaiter;
        synchronized (wipeWaiter2) {
            thread.start();
            try {
                wipeWaiter.wait();
            }
            catch (InterruptedException interruptedException) {
                Logger.error(LOG_TAG, "Wipe interrupted.");
            }
        }
        if (!wipeWaiter.sessionSucceeded) {
            Logger.error(LOG_TAG, "Failed to create session for wipe.");
            throw wipeWaiter.error;
        }
        if (!wipeWaiter.wipeSucceeded) {
            Logger.error(LOG_TAG, "Failed to wipe session.");
            throw wipeWaiter.error;
        }
        Logger.info(LOG_TAG, "Wiping stage complete.");
    }

    protected void wipeServer(final AuthHeaderProvider authHeaderProvider, final WipeServerDelegate wipeServerDelegate) {
        SyncStorageRequest syncStorageRequest;
        try {
            syncStorageRequest = new SyncStorageRequest(this.session.config.collectionURI(this.getCollection()));
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.warn(LOG_TAG, "Invalid URI in wipeServer.");
            wipeServerDelegate.onWipeFailed(uRISyntaxException);
            return;
        }
        syncStorageRequest.delegate = new SyncStorageRequestDelegate(){

            @Override
            public String ifUnmodifiedSince() {
                return null;
            }

            @Override
            public void handleRequestSuccess(SyncStorageResponse syncStorageResponse) {
                BaseResource.consumeEntity(syncStorageResponse);
                ServerSyncStage.this.resetLocal();
                wipeServerDelegate.onWiped(syncStorageResponse.normalizedWeaveTimestamp());
            }

            @Override
            public void handleRequestFailure(SyncStorageResponse syncStorageResponse) {
                Logger.warn(ServerSyncStage.LOG_TAG, "Got request failure " + syncStorageResponse.getStatusCode() + " in wipeServer.");
                ServerSyncStage.this.session.interpretHTTPFailure(syncStorageResponse.httpResponse());
                BaseResource.consumeEntity(syncStorageResponse);
                wipeServerDelegate.onWipeFailed(new HTTPFailureException(syncStorageResponse));
            }

            @Override
            public void handleRequestError(Exception exception) {
                Logger.warn(ServerSyncStage.LOG_TAG, "Got exception in wipeServer.", exception);
                wipeServerDelegate.onWipeFailed(exception);
            }

            @Override
            public AuthHeaderProvider getAuthHeaderProvider() {
                return authHeaderProvider;
            }
        };
        syncStorageRequest.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wipeServer(final GlobalSession globalSession) throws Exception {
        this.session = globalSession;
        final WipeWaiter wipeWaiter = new WipeWaiter();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ServerSyncStage.this.wipeServer(globalSession.getAuthHeaderProvider(), new WipeServerDelegate(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onWiped(long l) {
                        WipeWaiter wipeWaiter = wipeWaiter;
                        synchronized (wipeWaiter) {
                            wipeWaiter.notify();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onWipeFailed(Exception exception) {
                        WipeWaiter wipeWaiter = wipeWaiter;
                        synchronized (wipeWaiter) {
                            wipeWaiter.notify(exception, false);
                        }
                    }
                });
            }
        };
        Thread thread = new Thread(runnable);
        WipeWaiter wipeWaiter2 = wipeWaiter;
        synchronized (wipeWaiter2) {
            thread.start();
            try {
                wipeWaiter.wait();
            }
            catch (InterruptedException interruptedException) {
                Logger.error(LOG_TAG, "Server wipe interrupted.");
            }
        }
        if (!wipeWaiter.wipeSucceeded) {
            Logger.error(LOG_TAG, "Failed to wipe server.");
            throw wipeWaiter.error;
        }
        Logger.info(LOG_TAG, "Wiping server complete.");
    }

    @Override
    public void execute() throws NoSuchStageException {
        Synchronizer synchronizer;
        String string2 = this.getEngineName();
        Logger.debug(LOG_TAG, "Starting execute for " + string2);
        this.stageStartTimestamp = System.currentTimeMillis();
        try {
            if (!this.isEnabled()) {
                Logger.info(LOG_TAG, "Skipping stage " + string2 + ".");
                this.session.advance();
                return;
            }
        }
        catch (MetaGlobalException.MetaGlobalMalformedSyncIDException metaGlobalMalformedSyncIDException) {
            try {
                this.session.recordForMetaGlobalUpdate(string2, new EngineSettings(Utils.generateGuid(), this.getStorageVersion()));
                Logger.info(LOG_TAG, "Wiping server because malformed engine sync ID was found in meta/global.");
                this.wipeServer(this.session);
                Logger.info(LOG_TAG, "Wiped server after malformed engine sync ID found in meta/global.");
            }
            catch (Exception exception) {
                this.session.abort(exception, "Failed to wipe server after malformed engine sync ID found in meta/global.");
            }
        }
        catch (MetaGlobalException.MetaGlobalMalformedVersionException metaGlobalMalformedVersionException) {
            try {
                this.session.recordForMetaGlobalUpdate(string2, new EngineSettings(Utils.generateGuid(), this.getStorageVersion()));
                Logger.info(LOG_TAG, "Wiping server because malformed engine version was found in meta/global.");
                this.wipeServer(this.session);
                Logger.info(LOG_TAG, "Wiped server after malformed engine version found in meta/global.");
            }
            catch (Exception exception) {
                this.session.abort(exception, "Failed to wipe server after malformed engine version found in meta/global.");
            }
        }
        catch (MetaGlobalException.MetaGlobalStaleClientSyncIDException metaGlobalStaleClientSyncIDException) {
            Logger.warn(LOG_TAG, "Remote engine syncID different from local engine syncID: resetting local engine and assuming remote engine syncID.");
            this.resetLocalWithSyncID(metaGlobalStaleClientSyncIDException.serverSyncID);
        }
        catch (MetaGlobalException.MetaGlobalEngineStateChangedException metaGlobalEngineStateChangedException) {
            boolean bl = metaGlobalEngineStateChangedException.isEnabled;
            if (!bl) {
                this.session.removeEngineFromMetaGlobal(string2);
                this.session.config.declinedEngineNames.add(string2);
            } else {
                this.session.config.declinedEngineNames.remove(string2);
                String string3 = Utils.generateGuid();
                this.session.recordForMetaGlobalUpdate(string2, new EngineSettings(string3, this.getStorageVersion()));
                this.resetLocalWithSyncID(string3);
            }
            try {
                Logger.warn(LOG_TAG, "Wiping server because engine sync state changed.");
                this.wipeServer(this.session);
                Logger.warn(LOG_TAG, "Wiped server because engine sync state changed.");
            }
            catch (Exception exception) {
                this.session.abort(exception, "Failed to wipe server after engine sync state changed");
            }
            if (!bl) {
                Logger.warn(LOG_TAG, "Stage has been disabled. Advancing to next stage.");
                this.session.advance();
                return;
            }
        }
        catch (MetaGlobalException metaGlobalException) {
            this.session.abort(metaGlobalException, "Inappropriate meta/global; refusing to execute " + string2 + " stage.");
            return;
        }
        try {
            synchronizer = this.getConfiguredSynchronizer(this.session);
        }
        catch (NoCollectionKeysSetException noCollectionKeysSetException) {
            this.session.abort(noCollectionKeysSetException, "No CollectionKeys.");
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
            this.session.abort(uRISyntaxException, "Invalid URI syntax for server repository.");
            return;
        }
        catch (NonObjectJSONException nonObjectJSONException) {
            this.session.abort(nonObjectJSONException, "Invalid persisted JSON for config.");
            return;
        }
        catch (IOException iOException) {
            this.session.abort(iOException, "Invalid persisted JSON for config.");
            return;
        }
        catch (ParseException parseException) {
            this.session.abort((Exception)((Object)parseException), "Invalid persisted JSON for config.");
            return;
        }
        Logger.debug(LOG_TAG, "Invoking synchronizer.");
        synchronizer.synchronize(this.session.getContext(), this);
        Logger.debug(LOG_TAG, "Reached end of execute.");
    }

    protected String getStageDurationString() {
        return Utils.formatDuration(this.stageStartTimestamp, this.stageCompleteTimestamp);
    }

    @Override
    public void onSynchronized(Synchronizer synchronizer) {
        this.stageCompleteTimestamp = System.currentTimeMillis();
        Logger.debug(LOG_TAG, "onSynchronized.");
        SynchronizerConfiguration synchronizerConfiguration = synchronizer.save();
        if (synchronizerConfiguration != null) {
            this.persistConfig(synchronizerConfiguration);
        } else {
            Logger.warn(LOG_TAG, "Didn't get configuration from synchronizer after success.");
        }
        SynchronizerSession synchronizerSession = synchronizer.getSynchronizerSession();
        int n = synchronizerSession.getInboundCount();
        int n2 = synchronizerSession.getOutboundCount();
        Logger.info(LOG_TAG, "Stage " + this.getEngineName() + " received " + n + " and sent " + n2 + " records in " + this.getStageDurationString() + ".");
        Logger.info(LOG_TAG, "Advancing session.");
        this.session.advance();
    }

    @Override
    public void onSynchronizeFailed(Synchronizer synchronizer, Exception exception, String string2) {
        this.stageCompleteTimestamp = System.currentTimeMillis();
        Logger.warn(LOG_TAG, "Synchronize failed: " + string2, exception);
        if (exception instanceof HTTPFailureException) {
            SyncStorageResponse syncStorageResponse = ((HTTPFailureException)exception).response;
            if (syncStorageResponse.retryAfterInSeconds() > 0) {
                this.session.handleHTTPError(syncStorageResponse, string2);
                return;
            }
            this.session.interpretHTTPFailure(syncStorageResponse.httpResponse());
        }
        Logger.info(LOG_TAG, "Advancing session even though stage failed (took " + this.getStageDurationString() + "). Timestamps not persisted.");
        this.session.advance();
    }

    private class WipeWaiter {
        public boolean sessionSucceeded = true;
        public boolean wipeSucceeded = true;
        public Exception error;

        private WipeWaiter() {
        }

        public void notify(Exception exception, boolean bl) {
            this.sessionSucceeded = bl;
            this.wipeSucceeded = false;
            this.error = exception;
            this.notify();
        }
    }
}

