/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ListAdapter;
import java.util.ArrayList;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.tabs.TabStripAdapter;
import org.mozilla.gecko.tabs.TabStripItemView;
import org.mozilla.gecko.widget.TwoWayView;

public class TabStripView
extends TwoWayView {
    private static final String LOGTAG = "GeckoTabStrip";
    private final TabStripAdapter adapter;
    private final Drawable divider;
    private final Rect dividerPadding = new Rect();
    private boolean isPrivate;

    public TabStripView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setOrientation(TwoWayView.Orientation.HORIZONTAL);
        this.setChoiceMode(TwoWayView.ChoiceMode.SINGLE);
        this.setItemsCanFocus(true);
        this.setChildrenDrawingOrderEnabled(true);
        this.setWillNotDraw(false);
        Resources resources = this.getResources();
        this.divider = resources.getDrawable(R.drawable.new_tablet_tab_strip_divider);
        this.divider.getPadding(this.dividerPadding);
        int n = resources.getDimensionPixelSize(R.dimen.new_tablet_tab_strip_item_margin);
        this.setItemMargin(n);
        this.adapter = new TabStripAdapter(context);
        this.setAdapter((ListAdapter)this.adapter);
    }

    private View getViewForTab(Tab tab) {
        int n = this.adapter.getPositionForTab(tab);
        return this.getChildAt(n - this.getFirstVisiblePosition());
    }

    private int getPositionForSelectedTab() {
        return this.adapter.getPositionForTab(Tabs.getInstance().getSelectedTab());
    }

    private void updateSelectedStyle(int n) {
        this.setItemChecked(n, true);
    }

    private void updateSelectedPosition() {
        int n = this.getPositionForSelectedTab();
        if (n != -1) {
            this.updateSelectedStyle(n);
        }
    }

    private int getCheckedIndex(int n) {
        int n2 = this.getCheckedItemPosition() - this.getFirstVisiblePosition();
        if (n2 < 0 || n2 > n - 1) {
            return -1;
        }
        return n2;
    }

    void refreshTabs() {
        ArrayList<Tab> arrayList = new ArrayList<Tab>();
        for (Tab tab : Tabs.getInstance().getTabsInOrder()) {
            if (tab.isPrivate() != this.isPrivate) continue;
            arrayList.add(tab);
        }
        this.adapter.refresh(arrayList);
        this.updateSelectedPosition();
    }

    void clearTabs() {
        this.adapter.clear();
    }

    void removeTab(Tab tab) {
        this.adapter.removeTab(tab);
        this.updateSelectedPosition();
    }

    void selectTab(Tab tab) {
        if (tab.isPrivate() != this.isPrivate) {
            this.isPrivate = tab.isPrivate();
            this.refreshTabs();
        } else {
            this.updateSelectedPosition();
        }
    }

    void updateTab(Tab tab) {
        TabStripItemView tabStripItemView = (TabStripItemView)this.getViewForTab(tab);
        if (tabStripItemView != null) {
            tabStripItemView.updateFromTab(tab);
        }
    }

    protected int getChildDrawingOrder(int n, int n2) {
        int n3 = this.getCheckedIndex(n);
        if (n3 == -1) {
            return n2;
        }
        if (n2 == n - 1) {
            return n3;
        }
        if (n3 <= n2) {
            return n2 + 1;
        }
        return n2;
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        int n = this.getHeight() - this.getPaddingBottom() - this.dividerPadding.bottom;
        int n2 = n - this.divider.getIntrinsicHeight();
        int n3 = this.divider.getIntrinsicWidth();
        int n4 = this.getItemMargin();
        int n5 = this.getChildCount();
        int n6 = this.getCheckedIndex(n5);
        for (int i = 1; i < n5; ++i) {
            boolean bl;
            View view = this.getChildAt(i);
            boolean bl2 = view.isPressed() || this.getChildAt(i - 1).isPressed();
            boolean bl3 = bl = i == n6 || i == n6 + 1;
            if (bl2 || bl) continue;
            int n7 = view.getLeft() - n4 / 2 - n3;
            int n8 = n7 + n3;
            this.divider.setBounds(n7, n2, n8, n);
            this.divider.draw(canvas);
        }
    }
}

