/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.toolbar.BrowserToolbarTabletBase;

class BrowserToolbarNewTablet
extends BrowserToolbarTabletBase {
    private static final int FORWARD_ANIMATION_DURATION = 450;
    private final int urlBarViewOffset;
    private final int defaultForwardMargin;

    public BrowserToolbarNewTablet(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Resources resources = this.getResources();
        this.urlBarViewOffset = resources.getDimensionPixelSize(R.dimen.url_bar_offset_left);
        this.defaultForwardMargin = resources.getDimensionPixelSize(R.dimen.new_tablet_forward_default_offset);
    }

    @Override
    public boolean isAnimating() {
        return false;
    }

    @Override
    protected void triggerStartEditingTransition(PropertyAnimator propertyAnimator) {
        this.showUrlEditLayout();
    }

    @Override
    protected void triggerStopEditingTransition() {
        this.hideUrlEditLayout();
    }

    @Override
    protected void animateForwardButton(BrowserToolbarTabletBase.ForwardButtonAnimation forwardButtonAnimation) {
        final boolean bl = forwardButtonAnimation == BrowserToolbarTabletBase.ForwardButtonAnimation.SHOW;
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.forwardButton.getLayoutParams();
        if (marginLayoutParams.leftMargin > this.defaultForwardMargin && bl || marginLayoutParams.leftMargin == this.defaultForwardMargin && !bl) {
            return;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(this.isSwitchingTabs ? 10L : 450L);
        final int n = Math.round((float)this.forwardButton.getWidth() * 0.75f);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
                if (!bl) {
                    ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarNewTablet.this.urlDisplayLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarNewTablet.this.urlEditLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    BrowserToolbarNewTablet.this.requestLayout();
                }
            }

            @Override
            public void onPropertyAnimationEnd() {
                ViewGroup.MarginLayoutParams marginLayoutParams;
                if (bl) {
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarNewTablet.this.urlDisplayLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbarNewTablet.this.urlBarViewOffset;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarNewTablet.this.urlEditLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbarNewTablet.this.urlBarViewOffset;
                }
                BrowserToolbarNewTablet.this.urlDisplayLayout.finishForwardAnimation();
                marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarNewTablet.this.forwardButton.getLayoutParams();
                marginLayoutParams.leftMargin = BrowserToolbarNewTablet.this.defaultForwardMargin + (bl ? n : 0);
                ViewHelper.setTranslationX((View)BrowserToolbarNewTablet.this.forwardButton, 0.0f);
                BrowserToolbarNewTablet.this.requestLayout();
            }
        });
        this.prepareForwardAnimation(propertyAnimator, forwardButtonAnimation, n);
        propertyAnimator.start();
    }

    private void prepareForwardAnimation(PropertyAnimator propertyAnimator, BrowserToolbarTabletBase.ForwardButtonAnimation forwardButtonAnimation, int n) {
        if (forwardButtonAnimation == BrowserToolbarTabletBase.ForwardButtonAnimation.HIDE) {
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.TRANSLATION_X, -n);
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.ALPHA, 0.0f);
        } else {
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.TRANSLATION_X, n);
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.ALPHA, 1.0f);
        }
        this.urlDisplayLayout.prepareForwardAnimation(propertyAnimator, forwardButtonAnimation, n);
    }

    @Override
    public void triggerTabsPanelTransition(PropertyAnimator propertyAnimator, boolean bl) {
    }
}

