/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.graphics.Rect;
import android.text.Editable;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.BackgroundColorSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.CustomEditText;
import org.mozilla.gecko.InputMethods;
import org.mozilla.gecko.toolbar.AutocompleteHandler;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.toolbar.ToolbarPrefs;
import org.mozilla.gecko.util.GamepadUtils;
import org.mozilla.gecko.util.StringUtils;

public class ToolbarEditText
extends CustomEditText
implements AutocompleteHandler {
    private static final String LOGTAG = "GeckoToolbarEditText";
    private static final NoCopySpan AUTOCOMPLETE_SPAN = new NoCopySpan.Concrete();
    private final Context mContext;
    private BrowserToolbar.OnCommitListener mCommitListener;
    private BrowserToolbar.OnDismissListener mDismissListener;
    private BrowserToolbar.OnFilterListener mFilterListener;
    private ToolbarPrefs mPrefs;
    private String mAutoCompleteResult = "";
    private int mAutoCompletePrefixLength;
    private boolean mSettingAutoComplete;
    private Object[] mAutoCompleteSpans;
    private boolean mDiscardAutoCompleteResult;

    public ToolbarEditText(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
    }

    void setOnCommitListener(BrowserToolbar.OnCommitListener onCommitListener) {
        this.mCommitListener = onCommitListener;
    }

    void setOnDismissListener(BrowserToolbar.OnDismissListener onDismissListener) {
        this.mDismissListener = onDismissListener;
    }

    void setOnFilterListener(BrowserToolbar.OnFilterListener onFilterListener) {
        this.mFilterListener = onFilterListener;
    }

    @Override
    public void onAttachedToWindow() {
        this.setOnKeyListener(new KeyListener());
        this.setOnKeyPreImeListener(new KeyPreImeListener());
        this.setOnSelectionChangedListener(new SelectionChangeListener());
        this.addTextChangedListener(new TextChangeListener());
    }

    public void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        if (bl) {
            this.resetAutocompleteState();
            return;
        }
        this.removeAutocomplete(this.getText());
        InputMethodManager inputMethodManager = InputMethods.getInputMethodManager(this.mContext);
        try {
            inputMethodManager.restartInput((View)this);
            inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
        catch (NullPointerException nullPointerException) {
            Log.e((String)LOGTAG, (String)"InputMethodManagerService, why are you throwing a NullPointerException? See bug 782096", (Throwable)nullPointerException);
        }
    }

    public void setText(CharSequence charSequence, TextView.BufferType bufferType) {
        super.setText(charSequence, bufferType);
        this.resetAutocompleteState();
    }

    void setToolbarPrefs(ToolbarPrefs toolbarPrefs) {
        this.mPrefs = toolbarPrefs;
    }

    private void beginSettingAutocomplete() {
        this.beginBatchEdit();
        this.mSettingAutoComplete = true;
    }

    private void endSettingAutocomplete() {
        this.mSettingAutoComplete = false;
        this.endBatchEdit();
    }

    private void resetAutocompleteState() {
        this.mAutoCompleteSpans = new Object[]{AUTOCOMPLETE_SPAN, new BackgroundColorSpan(this.getHighlightColor())};
        this.mAutoCompleteResult = "";
        this.mAutoCompletePrefixLength = this.getText().length();
        this.setCursorVisible(true);
    }

    private static String getNonAutocompleteText(Editable editable) {
        int n = editable.getSpanStart((Object)AUTOCOMPLETE_SPAN);
        if (n < 0) {
            return editable.toString();
        }
        return TextUtils.substring((CharSequence)editable, (int)0, (int)n);
    }

    private boolean removeAutocomplete(Editable editable) {
        int n = editable.getSpanStart((Object)AUTOCOMPLETE_SPAN);
        if (n < 0) {
            return false;
        }
        this.beginSettingAutocomplete();
        editable.delete(n, editable.length());
        this.mAutoCompleteResult = "";
        this.setCursorVisible(true);
        this.endSettingAutocomplete();
        return true;
    }

    private boolean commitAutocomplete(Editable editable) {
        int n = editable.getSpanStart((Object)AUTOCOMPLETE_SPAN);
        if (n < 0) {
            return false;
        }
        this.beginSettingAutocomplete();
        for (Object object : this.mAutoCompleteSpans) {
            editable.removeSpan(object);
        }
        this.mAutoCompletePrefixLength = editable.length();
        this.setCursorVisible(true);
        this.endSettingAutocomplete();
        if (this.mFilterListener != null) {
            this.mFilterListener.onFilter(editable.toString(), null);
        }
        return true;
    }

    @Override
    public final void onAutocomplete(String string2) {
        if (this.mDiscardAutoCompleteResult) {
            return;
        }
        if (!this.isEnabled() || string2 == null) {
            this.mAutoCompleteResult = "";
            return;
        }
        Editable editable = this.getText();
        int n = editable.length();
        int n2 = string2.length();
        int n3 = editable.getSpanStart((Object)AUTOCOMPLETE_SPAN);
        this.mAutoCompleteResult = string2;
        if (n3 > -1) {
            if (!TextUtils.regionMatches((CharSequence)string2, (int)0, (CharSequence)editable, (int)0, (int)n3)) {
                return;
            }
            this.beginSettingAutocomplete();
            editable.replace(n3, n, (CharSequence)string2, n3, n2);
            if (n3 == n2) {
                this.setCursorVisible(true);
            }
            this.endSettingAutocomplete();
        } else {
            if (n2 <= n || !TextUtils.regionMatches((CharSequence)string2, (int)0, (CharSequence)editable, (int)0, (int)n)) {
                return;
            }
            Object[] objectArray = editable.getSpans(n, n, Object.class);
            int[] nArray = new int[objectArray.length];
            int[] nArray2 = new int[objectArray.length];
            int[] nArray3 = new int[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                int n4 = editable.getSpanFlags(object);
                if ((n4 & 0x100) == 0 && object != Selection.SELECTION_START && object != Selection.SELECTION_END) continue;
                nArray[i] = editable.getSpanStart(object);
                nArray2[i] = editable.getSpanEnd(object);
                nArray3[i] = n4;
            }
            this.beginSettingAutocomplete();
            editable.append((CharSequence)string2, n, n2);
            for (Object object : this.mAutoCompleteSpans) {
                editable.setSpan(object, n, n2, 33);
            }
            this.setCursorVisible(false);
            this.bringPointIntoView(n2);
            for (int i = 0; i < objectArray.length; ++i) {
                int n5 = nArray3[i];
                if (n5 == 0) continue;
                editable.setSpan(objectArray[i], nArray[i], nArray2[i], n5);
            }
            this.endSettingAutocomplete();
        }
    }

    private static boolean hasCompositionString(Editable editable) {
        Object[] objectArray = editable.getSpans(0, editable.length(), Object.class);
        if (objectArray != null) {
            for (Object object : objectArray) {
                if ((editable.getSpanFlags(object) & 0x100) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        InputConnection inputConnection = super.onCreateInputConnection(editorInfo);
        if (inputConnection == null) {
            return null;
        }
        return new InputConnectionWrapper(inputConnection, false){

            public boolean deleteSurroundingText(int n, int n2) {
                if (ToolbarEditText.this.removeAutocomplete(ToolbarEditText.this.getText())) {
                    InputMethodManager inputMethodManager = InputMethods.getInputMethodManager(ToolbarEditText.this.mContext);
                    if (inputMethodManager != null) {
                        inputMethodManager.restartInput((View)ToolbarEditText.this);
                    }
                    return false;
                }
                return super.deleteSurroundingText(n, n2);
            }

            private boolean removeAutocompleteOnComposing(CharSequence charSequence) {
                Editable editable = ToolbarEditText.this.getText();
                int n = BaseInputConnection.getComposingSpanStart((Spannable)editable);
                int n2 = BaseInputConnection.getComposingSpanEnd((Spannable)editable);
                if (n >= 0 && n2 >= 0 && n2 - n > charSequence.length() && ToolbarEditText.this.removeAutocomplete(editable)) {
                    this.finishComposingText();
                    this.setComposingRegion(n, n2);
                    return true;
                }
                return false;
            }

            public boolean commitText(CharSequence charSequence, int n) {
                if (this.removeAutocompleteOnComposing(charSequence)) {
                    return false;
                }
                return super.commitText(charSequence, n);
            }

            public boolean setComposingText(CharSequence charSequence, int n) {
                if (this.removeAutocompleteOnComposing(charSequence)) {
                    return false;
                }
                return super.setComposingText(charSequence, n);
            }
        };
    }

    private class KeyListener
    implements View.OnKeyListener {
        private KeyListener() {
        }

        public boolean onKey(View view, int n, KeyEvent keyEvent) {
            if (n == 66 || GamepadUtils.isActionKey((KeyEvent)keyEvent)) {
                if (keyEvent.getAction() != 0) {
                    return true;
                }
                if (ToolbarEditText.this.mCommitListener != null) {
                    ToolbarEditText.this.mCommitListener.onCommit();
                }
                return true;
            }
            if (GamepadUtils.isBackKey((KeyEvent)keyEvent)) {
                if (ToolbarEditText.this.mDismissListener != null) {
                    ToolbarEditText.this.mDismissListener.onDismiss();
                }
                return true;
            }
            return (n == 67 || AppConstants.Versions.feature11Plus && n == 112) && ToolbarEditText.this.removeAutocomplete(ToolbarEditText.this.getText());
        }
    }

    private class KeyPreImeListener
    implements CustomEditText.OnKeyPreImeListener {
        private KeyPreImeListener() {
        }

        @Override
        public boolean onKeyPreIme(View view, int n, KeyEvent keyEvent) {
            Editable editable;
            if (keyEvent.getAction() != 0) {
                return false;
            }
            if (n == 66 && !ToolbarEditText.hasCompositionString(editable = ToolbarEditText.this.getText())) {
                if (ToolbarEditText.this.mCommitListener != null) {
                    ToolbarEditText.this.mCommitListener.onCommit();
                }
                return true;
            }
            if (n == 4) {
                ToolbarEditText.this.clearFocus();
                return true;
            }
            return false;
        }
    }

    private class TextChangeListener
    implements TextWatcher {
        private TextChangeListener() {
        }

        public void afterTextChanged(Editable editable) {
            if (!ToolbarEditText.this.isEnabled() || ToolbarEditText.this.mSettingAutoComplete) {
                return;
            }
            String string2 = ToolbarEditText.getNonAutocompleteText(editable);
            int n = string2.length();
            boolean bl = ToolbarEditText.this.mPrefs.shouldAutocomplete();
            if (StringUtils.isSearchQuery((String)string2, (boolean)false)) {
                bl = false;
            } else if (ToolbarEditText.this.mAutoCompletePrefixLength > n) {
                bl = false;
            }
            ToolbarEditText.this.mAutoCompletePrefixLength = n;
            ToolbarEditText.this.mDiscardAutoCompleteResult = !bl;
            if (bl && ToolbarEditText.this.mAutoCompleteResult.startsWith(string2)) {
                ToolbarEditText.this.onAutocomplete(ToolbarEditText.this.mAutoCompleteResult);
                bl = false;
            } else {
                ToolbarEditText.this.removeAutocomplete(editable);
            }
            if (ToolbarEditText.this.mFilterListener != null) {
                ToolbarEditText.this.mFilterListener.onFilter(string2, bl ? ToolbarEditText.this : null);
            }
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }

    private class SelectionChangeListener
    implements CustomEditText.OnSelectionChangedListener {
        private SelectionChangeListener() {
        }

        @Override
        public void onSelectionChanged(int n, int n2) {
            Editable editable = ToolbarEditText.this.getText();
            int n3 = editable.getSpanStart((Object)AUTOCOMPLETE_SPAN);
            if (n3 < 0 || n3 == n && n3 == n2) {
                return;
            }
            if (n <= n3 && n2 <= n3) {
                ToolbarEditText.this.removeAutocomplete(editable);
            } else {
                ToolbarEditText.this.commitAutocomplete(editable);
            }
        }
    }
}

