/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListView;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.ValueAnimator;
import com.nineoldandroids.view.ViewHelper;
import com.nineoldandroids.view.ViewPropertyAnimator;
import org.mozilla.gecko.R;

public class SwipeDismissListViewTouchListener
implements View.OnTouchListener {
    private final int mSlop;
    private final int mMinFlingVelocity;
    private final int mMaxFlingVelocity;
    private final long mAnimationTime;
    private final ListView mListView;
    private final OnDismissCallback mCallback;
    private int mViewWidth = 1;
    private float mDownX;
    private boolean mSwiping;
    private VelocityTracker mVelocityTracker;
    private int mDownPosition;
    private View mDownView;
    private boolean mPaused;
    private boolean mDismissing;

    public SwipeDismissListViewTouchListener(ListView listView, OnDismissCallback onDismissCallback) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)listView.getContext());
        this.mSlop = viewConfiguration.getScaledTouchSlop();
        this.mMinFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mAnimationTime = listView.getContext().getResources().getInteger(0x10E0000);
        this.mListView = listView;
        this.mCallback = onDismissCallback;
    }

    public void setEnabled(boolean bl) {
        this.mPaused = !bl;
    }

    public AbsListView.OnScrollListener makeScrollListener() {
        return new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int n) {
                SwipeDismissListViewTouchListener.this.setEnabled(n != 1);
            }

            public void onScroll(AbsListView absListView, int n, int n2, int n3) {
            }
        };
    }

    public AbsListView.RecyclerListener makeRecyclerListener() {
        return new AbsListView.RecyclerListener(){

            public void onMovedToScrapHeap(View view) {
                Object object = view.getTag(R.id.original_height);
                if (object instanceof Integer) {
                    ViewHelper.setAlpha((View)view, (float)1.0f);
                    ViewHelper.setTranslationX((View)view, (float)0.0f);
                    ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                    layoutParams.height = (Integer)object;
                    view.setLayoutParams(layoutParams);
                    view.setTag(R.id.original_height, null);
                }
            }
        };
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (this.mViewWidth < 2) {
            this.mViewWidth = this.mListView.getWidth();
        }
        switch (motionEvent.getActionMasked()) {
            case 0: {
                if (this.mPaused) {
                    return false;
                }
                if (this.mDismissing) {
                    return true;
                }
                Rect rect = new Rect();
                int n = this.mListView.getChildCount();
                int[] nArray = new int[2];
                this.mListView.getLocationOnScreen(nArray);
                int n2 = (int)motionEvent.getRawX() - nArray[0];
                int n3 = (int)motionEvent.getRawY() - nArray[1];
                for (int i = 0; i < n; ++i) {
                    View view2 = this.mListView.getChildAt(i);
                    view2.getHitRect(rect);
                    if (!rect.contains(n2, n3)) continue;
                    this.mDownView = view2;
                    break;
                }
                if (this.mDownView != null) {
                    this.mDownX = motionEvent.getRawX();
                    this.mDownPosition = this.mListView.getPositionForView(this.mDownView);
                    this.mVelocityTracker = VelocityTracker.obtain();
                    this.mVelocityTracker.addMovement(motionEvent);
                }
                view.onTouchEvent(motionEvent);
                return true;
            }
            case 1: {
                if (this.mVelocityTracker == null) break;
                float f = motionEvent.getRawX() - this.mDownX;
                this.mVelocityTracker.addMovement(motionEvent);
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float f2 = Math.abs(this.mVelocityTracker.getXVelocity());
                float f3 = Math.abs(this.mVelocityTracker.getYVelocity());
                boolean bl = false;
                boolean bl2 = false;
                if (Math.abs(f) > (float)(this.mViewWidth / 2)) {
                    bl = true;
                    bl2 = f > 0.0f;
                } else if ((float)this.mMinFlingVelocity <= f2 && f2 <= (float)this.mMaxFlingVelocity && f3 < f2) {
                    bl = true;
                    boolean bl3 = bl2 = this.mVelocityTracker.getXVelocity() > 0.0f;
                }
                if (bl) {
                    this.mDismissing = true;
                    final View view3 = this.mDownView;
                    final int n = this.mDownPosition;
                    ViewPropertyAnimator.animate((View)this.mDownView).translationX(bl2 ? (float)this.mViewWidth : (float)(-this.mViewWidth)).alpha(0.0f).setDuration(this.mAnimationTime).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animator) {
                            SwipeDismissListViewTouchListener.this.performDismiss(view3, n);
                        }
                    });
                } else {
                    ViewPropertyAnimator.animate((View)this.mDownView).translationX(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
                }
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mDownX = 0.0f;
                this.mDownView = null;
                this.mDownPosition = -1;
                this.mSwiping = false;
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null || this.mPaused) break;
                this.mVelocityTracker.addMovement(motionEvent);
                float f = motionEvent.getRawX() - this.mDownX;
                if (Math.abs(f) > (float)this.mSlop) {
                    this.mSwiping = true;
                    this.mListView.requestDisallowInterceptTouchEvent(true);
                    MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                    motionEvent2.setAction(3 | motionEvent.getActionIndex() << 8);
                    this.mListView.onTouchEvent(motionEvent2);
                    motionEvent2.recycle();
                }
                if (!this.mSwiping) break;
                ViewHelper.setTranslationX((View)this.mDownView, (float)f);
                ViewHelper.setAlpha((View)this.mDownView, (float)Math.max(0.0f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(f) / (float)this.mViewWidth)));
                return true;
            }
        }
        return false;
    }

    private void performDismiss(final View view, final int n) {
        final ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        final int n2 = view.getHeight();
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{n2, 1}).setDuration(this.mAnimationTime);
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                view.setTag(R.id.original_height, (Object)n2);
                SwipeDismissListViewTouchListener.this.mCallback.onDismiss(SwipeDismissListViewTouchListener.this.mListView, n);
                SwipeDismissListViewTouchListener.this.mDismissing = false;
            }
        });
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                layoutParams.height = (Integer)valueAnimator.getAnimatedValue();
                view.setLayoutParams(layoutParams);
            }
        });
        valueAnimator.start();
    }

    public static interface OnDismissCallback {
        public void onDismiss(ListView var1, int var2);
    }
}

