/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mozglue;

import java.nio.ByteBuffer;

public final class DirectBufferAllocator {
    private DirectBufferAllocator() {
    }

    public static ByteBuffer allocate(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid size " + n);
        }
        ByteBuffer byteBuffer = DirectBufferAllocator.nativeAllocateDirectBuffer(n);
        if (byteBuffer == null) {
            throw new OutOfMemoryError("allocateDirectBuffer() returned null");
        }
        if (!byteBuffer.isDirect()) {
            throw new AssertionError((Object)"allocateDirectBuffer() did not return a direct buffer");
        }
        return byteBuffer;
    }

    public static ByteBuffer free(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("buffer must be direct");
        }
        DirectBufferAllocator.nativeFreeDirectBuffer(byteBuffer);
        return null;
    }

    private static native ByteBuffer nativeAllocateDirectBuffer(long var0);

    private static native void nativeFreeDirectBuffer(ByteBuffer var0);
}

