/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.tasks;

import android.content.Context;
import android.os.AsyncTask;
import java.util.concurrent.CountDownLatch;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClientException;

public abstract class FxAccountSetupTask<T>
extends AsyncTask<Void, Void, InnerRequestDelegate<T>> {
    private static final String LOG_TAG = FxAccountSetupTask.class.getSimpleName();
    protected final Context context;
    protected final FxAccountClient client;
    protected final ProgressDisplay progressDisplay;
    protected byte[] quickStretchedPW;
    protected final CountDownLatch latch = new CountDownLatch(1);
    protected final InnerRequestDelegate<T> innerDelegate = new InnerRequestDelegate(this.latch);
    protected final FxAccountClient10.RequestDelegate<T> delegate;

    public FxAccountSetupTask(Context context, ProgressDisplay progressDisplay, FxAccountClient fxAccountClient, FxAccountClient10.RequestDelegate<T> requestDelegate) {
        this.context = context;
        this.client = fxAccountClient;
        this.delegate = requestDelegate;
        this.progressDisplay = progressDisplay;
    }

    protected void onPreExecute() {
        if (this.progressDisplay != null) {
            this.progressDisplay.showProgress();
        }
    }

    protected void onPostExecute(InnerRequestDelegate<T> innerRequestDelegate) {
        if (this.progressDisplay != null) {
            this.progressDisplay.dismissProgress();
        }
        if (this.innerDelegate.failure != null) {
            this.delegate.handleFailure(this.innerDelegate.failure);
        } else if (this.innerDelegate.exception != null) {
            this.delegate.handleError(this.innerDelegate.exception);
        } else {
            this.delegate.handleSuccess(innerRequestDelegate.response);
        }
    }

    protected void onCancelled(InnerRequestDelegate<T> innerRequestDelegate) {
        if (this.progressDisplay != null) {
            this.progressDisplay.dismissProgress();
        }
        this.delegate.handleError(new IllegalStateException("Task was cancelled."));
    }

    protected static class InnerRequestDelegate<T>
    implements FxAccountClient10.RequestDelegate<T> {
        protected final CountDownLatch latch;
        public T response;
        public Exception exception;
        public FxAccountClientException.FxAccountClientRemoteException failure;

        protected InnerRequestDelegate(CountDownLatch countDownLatch) {
            this.latch = countDownLatch;
        }

        @Override
        public void handleError(Exception exception) {
            Logger.error(LOG_TAG, "Got exception.");
            this.exception = exception;
            this.latch.countDown();
        }

        @Override
        public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
            Logger.warn(LOG_TAG, "Got failure.");
            this.failure = fxAccountClientRemoteException;
            this.latch.countDown();
        }

        @Override
        public void handleSuccess(T t) {
            Logger.info(LOG_TAG, "Got success.");
            this.response = t;
            this.latch.countDown();
        }
    }

    public static interface ProgressDisplay {
        public void showProgress();

        public void dismissProgress();
    }
}

