/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import org.mozilla.gecko.R;

public class TopSitesThumbnailView
extends ImageView {
    private static final String LOGTAG = "GeckoTopSitesThumbnailView";
    private static final int COLOR_FILTER = 0x46FFFFFF;
    private static final int DEFAULT_COLOR = -1249037;
    private final float mStrokeWidth;
    private static final Paint sBorderPaint = new Paint(1);

    public TopSitesThumbnailView(Context context) {
        this(context, null);
        this.setWillNotDraw(false);
    }

    public TopSitesThumbnailView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.topSitesThumbnailViewStyle);
    }

    public TopSitesThumbnailView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mStrokeWidth = this.getResources().getDisplayMetrics().density * 2.0f;
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = this.getMeasuredWidth();
        int n4 = (int)((float)n3 * 0.571f);
        this.setMeasuredDimension(n3, n4);
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.getBackground() == null) {
            sBorderPaint.setStrokeWidth(this.mStrokeWidth);
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), sBorderPaint);
        }
    }

    public void setBackgroundColorWithOpacityFilter(int n) {
        this.setBackgroundColor(n & 0x46FFFFFF);
    }

    public void setBackgroundColor(int n) {
        if (n == 0) {
            n = -1249037;
        }
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.top_sites_thumbnail_bg);
        drawable2.setColorFilter(n, PorterDuff.Mode.SRC_ATOP);
        this.setBackgroundDrawable(drawable2);
    }

    static {
        sBorderPaint.setColor(-3155487);
        sBorderPaint.setStyle(Paint.Style.STROKE);
    }
}

