/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.LightweightTheme;
import org.mozilla.gecko.LightweightThemeDrawable;
import org.mozilla.gecko.R;
import org.mozilla.gecko.toolbar.CanvasDelegate;
import org.mozilla.gecko.widget.ThemedImageButton;

public class ShapedButton
extends ThemedImageButton
implements CanvasDelegate.DrawManager {
    protected final LightweightTheme mTheme;
    protected final Path mPath;
    protected final CanvasDelegate mCanvasDelegate;

    public ShapedButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mTheme = ((GeckoApplication)context.getApplicationContext()).getLightweightTheme();
        this.mPath = new Path();
        this.mCanvasDelegate = new CanvasDelegate(this, PorterDuff.Mode.DST_IN);
        this.setWillNotDraw(false);
    }

    public void draw(Canvas canvas) {
        if (this.mCanvasDelegate != null) {
            this.mCanvasDelegate.draw(canvas, this.mPath, this.getWidth(), this.getHeight());
        } else {
            this.defaultDraw(canvas);
        }
    }

    @Override
    public void defaultDraw(Canvas canvas) {
        super.draw(canvas);
    }

    @Override
    public void onLightweightThemeChanged() {
        int n = this.getResources().getColor(R.color.background_tabs);
        LightweightThemeDrawable lightweightThemeDrawable = this.mTheme.getColorDrawable((View)this, n);
        if (lightweightThemeDrawable == null) {
            return;
        }
        lightweightThemeDrawable.setAlpha(34, 34);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(PRESSED_ENABLED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_shaped));
        stateListDrawable.addState(FOCUSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_shaped_focused));
        stateListDrawable.addState(PRIVATE_STATE_SET, (Drawable)this.getColorDrawable(R.color.background_tabs));
        stateListDrawable.addState(EMPTY_STATE_SET, (Drawable)lightweightThemeDrawable);
        this.setBackgroundDrawable((Drawable)stateListDrawable);
    }

    @Override
    public void onLightweightThemeReset() {
        this.setBackgroundResource(R.drawable.shaped_button);
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        if (this.getBackground() == null || drawable2 == null) {
            super.setBackgroundDrawable(drawable2);
            return;
        }
        int[] nArray = new int[]{this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom()};
        drawable2.setLevel(this.getBackground().getLevel());
        super.setBackgroundDrawable(drawable2);
        this.setPadding(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public void setBackgroundResource(int n) {
        this.setBackgroundDrawable(this.getResources().getDrawable(n));
    }
}

