/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.client.cache;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.ProtocolVersion;
import ch.boye.httpclientandroidlib.StatusLine;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.cache.Resource;
import ch.boye.httpclientandroidlib.client.utils.DateUtils;
import ch.boye.httpclientandroidlib.message.HeaderGroup;
import ch.boye.httpclientandroidlib.util.Args;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Immutable
public class HttpCacheEntry
implements Serializable {
    private static final long serialVersionUID = -6300496422359477413L;
    private final Date requestDate;
    private final Date responseDate;
    private final StatusLine statusLine;
    private final HeaderGroup responseHeaders;
    private final Resource resource;
    private final Map<String, String> variantMap;
    private final Date date;

    public HttpCacheEntry(Date date, Date date2, StatusLine statusLine, Header[] headerArray, Resource resource, Map<String, String> map) {
        Args.notNull(date, "Request date");
        Args.notNull(date2, "Response date");
        Args.notNull(statusLine, "Status line");
        Args.notNull(headerArray, "Response headers");
        this.requestDate = date;
        this.responseDate = date2;
        this.statusLine = statusLine;
        this.responseHeaders = new HeaderGroup();
        this.responseHeaders.setHeaders(headerArray);
        this.resource = resource;
        this.variantMap = map != null ? new HashMap<String, String>(map) : null;
        this.date = this.parseDate();
    }

    public HttpCacheEntry(Date date, Date date2, StatusLine statusLine, Header[] headerArray, Resource resource) {
        this(date, date2, statusLine, headerArray, resource, new HashMap<String, String>());
    }

    private Date parseDate() {
        Header header = this.getFirstHeader("Date");
        if (header == null) {
            return null;
        }
        return DateUtils.parseDate(header.getValue());
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.statusLine.getProtocolVersion();
    }

    public String getReasonPhrase() {
        return this.statusLine.getReasonPhrase();
    }

    public int getStatusCode() {
        return this.statusLine.getStatusCode();
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public Date getResponseDate() {
        return this.responseDate;
    }

    public Header[] getAllHeaders() {
        return this.responseHeaders.getAllHeaders();
    }

    public Header getFirstHeader(String string) {
        return this.responseHeaders.getFirstHeader(string);
    }

    public Header[] getHeaders(String string) {
        return this.responseHeaders.getHeaders(string);
    }

    public Date getDate() {
        return this.date;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean hasVariants() {
        return this.getFirstHeader("Vary") != null;
    }

    public Map<String, String> getVariantMap() {
        return Collections.unmodifiableMap(this.variantMap);
    }

    public String toString() {
        return "[request date=" + this.requestDate + "; response date=" + this.responseDate + "; statusLine=" + this.statusLine + "]";
    }
}

