/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.prompts;

import android.content.Context;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.prompts.Prompt;
import org.mozilla.gecko.prompts.PromptListItem;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class PromptService
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoPromptService";
    private final Context mContext;

    public PromptService(Context context) {
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Prompt:Show", "Prompt:ShowTop");
        this.mContext = context;
    }

    public void destroy() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Prompt:Show", "Prompt:ShowTop");
    }

    public void show(final String string2, final String string3, final PromptListItem[] promptListItemArray, final int n, final Prompt.PromptCallback promptCallback) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Prompt prompt = new Prompt(PromptService.this.mContext, promptCallback);
                prompt.show(string2, string3, promptListItemArray, n);
            }
        });
    }

    public void handleMessage(String string2, final JSONObject jSONObject) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Prompt prompt = new Prompt(PromptService.this.mContext, new Prompt.PromptCallback(){

                    @Override
                    public void onPromptFinished(String string2) {
                        try {
                            EventDispatcher.sendResponse(jSONObject, new JSONObject(string2));
                        }
                        catch (JSONException jSONException) {
                            Log.i((String)PromptService.LOGTAG, (String)"Error building json response", (Throwable)jSONException);
                        }
                    }
                });
                prompt.show(jSONObject);
            }
        });
    }
}

