/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.util;

import com.nineoldandroids.util.NoSuchPropertyException;
import com.nineoldandroids.util.Property;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ReflectiveProperty<T, V>
extends Property<T, V> {
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_IS = "is";
    private static final String PREFIX_SET = "set";
    private Method mSetter;
    private Method mGetter;
    private Field mField;

    public ReflectiveProperty(Class<T> clazz, Class<V> clazz2, String string) {
        super(clazz2, string);
        char c = Character.toUpperCase(string.charAt(0));
        String string2 = string.substring(1);
        String string3 = c + string2;
        String string4 = PREFIX_GET + string3;
        try {
            this.mGetter = clazz.getMethod(string4, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                this.mGetter = clazz.getDeclaredMethod(string4, null);
                this.mGetter.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                string4 = PREFIX_IS + string3;
                try {
                    this.mGetter = clazz.getMethod(string4, null);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    try {
                        this.mGetter = clazz.getDeclaredMethod(string4, null);
                        this.mGetter.setAccessible(true);
                    }
                    catch (NoSuchMethodException noSuchMethodException4) {
                        try {
                            this.mField = clazz.getField(string);
                            Class<?> clazz3 = this.mField.getType();
                            if (!this.typesMatch(clazz2, clazz3)) {
                                throw new NoSuchPropertyException("Underlying type (" + clazz3 + ") " + "does not match Property type (" + clazz2 + ")");
                            }
                            return;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            throw new NoSuchPropertyException("No accessor method or field found for property with name " + string);
                        }
                    }
                }
            }
        }
        Class<?> clazz4 = this.mGetter.getReturnType();
        if (!this.typesMatch(clazz2, clazz4)) {
            throw new NoSuchPropertyException("Underlying type (" + clazz4 + ") " + "does not match Property type (" + clazz2 + ")");
        }
        String string5 = PREFIX_SET + string3;
        try {
            this.mSetter = clazz.getDeclaredMethod(string5, clazz4);
            this.mSetter.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private boolean typesMatch(Class<V> clazz, Class clazz2) {
        if (clazz2 != clazz) {
            if (clazz2.isPrimitive()) {
                return clazz2 == Float.TYPE && clazz == Float.class || clazz2 == Integer.TYPE && clazz == Integer.class || clazz2 == Boolean.TYPE && clazz == Boolean.class || clazz2 == Long.TYPE && clazz == Long.class || clazz2 == Double.TYPE && clazz == Double.class || clazz2 == Short.TYPE && clazz == Short.class || clazz2 == Byte.TYPE && clazz == Byte.class || clazz2 == Character.TYPE && clazz == Character.class;
            }
            return false;
        }
        return true;
    }

    @Override
    public void set(T t, V v) {
        if (this.mSetter != null) {
            try {
                this.mSetter.invoke(t, v);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
        } else if (this.mField != null) {
            try {
                this.mField.set(t, v);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        } else {
            throw new UnsupportedOperationException("Property " + this.getName() + " is read-only");
        }
    }

    @Override
    public V get(T t) {
        if (this.mGetter != null) {
            try {
                return (V)this.mGetter.invoke(t, (Object[])null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
        }
        if (this.mField != null) {
            try {
                return (V)this.mField.get(t);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean isReadOnly() {
        return this.mSetter == null && this.mField == null;
    }
}

