/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.graphics.Bitmap;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Utils;
import java.util.LinkedHashMap;
import java.util.Map;

public class LruCache
implements Cache {
    final LinkedHashMap<String, Bitmap> map;
    private final int maxSize;
    private int size;
    private int putCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    public LruCache(Context context) {
        this(Utils.calculateMemoryCacheSize(context));
    }

    public LruCache(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Max size must be positive.");
        }
        this.maxSize = n;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap get(String string) {
        if (string == null) {
            throw new NullPointerException("key == null");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            Bitmap bitmap = this.map.get(string);
            if (bitmap != null) {
                ++this.hitCount;
                return bitmap;
            }
            ++this.missCount;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String string, Bitmap bitmap) {
        if (string == null || bitmap == null) {
            throw new NullPointerException("key == null || bitmap == null");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            ++this.putCount;
            this.size += Utils.getBitmapBytes(bitmap);
            Bitmap bitmap2 = this.map.put(string, bitmap);
            if (bitmap2 != null) {
                this.size -= Utils.getBitmapBytes(bitmap2);
            }
        }
        this.trimToSize(this.maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize(int n) {
        while (true) {
            LruCache lruCache = this;
            synchronized (lruCache) {
                if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= n || this.map.isEmpty()) {
                    break;
                }
                Map.Entry<String, Bitmap> entry = this.map.entrySet().iterator().next();
                String string = entry.getKey();
                Bitmap bitmap = entry.getValue();
                this.map.remove(string);
                this.size -= Utils.getBitmapBytes(bitmap);
                ++this.evictionCount;
            }
        }
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    @Override
    public final synchronized int size() {
        return this.size;
    }

    @Override
    public final synchronized int maxSize() {
        return this.maxSize;
    }

    @Override
    public final synchronized void clear() {
        this.evictAll();
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int missCount() {
        return this.missCount;
    }

    public final synchronized int putCount() {
        return this.putCount;
    }

    public final synchronized int evictionCount() {
        return this.evictionCount;
    }
}

