/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.client.entity;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.client.entity.LazyDecompressingInputStream;
import ch.boye.httpclientandroidlib.entity.HttpEntityWrapper;
import ch.boye.httpclientandroidlib.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class DecompressingEntity
extends HttpEntityWrapper {
    private static final int BUFFER_SIZE = 2048;
    private InputStream content;

    public DecompressingEntity(HttpEntity httpEntity) {
        super(httpEntity);
    }

    abstract InputStream decorate(InputStream var1) throws IOException;

    private InputStream getDecompressingStream() throws IOException {
        InputStream inputStream = this.wrappedEntity.getContent();
        return new LazyDecompressingInputStream(inputStream, this);
    }

    @Override
    public InputStream getContent() throws IOException {
        if (this.wrappedEntity.isStreaming()) {
            if (this.content == null) {
                this.content = this.getDecompressingStream();
            }
            return this.content;
        }
        return this.getDecompressingStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        try (InputStream inputStream = this.getContent();){
            int n;
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
    }
}

