/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.entity.mime;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.entity.ContentType;
import ch.boye.httpclientandroidlib.entity.mime.AbstractMultipartForm;
import ch.boye.httpclientandroidlib.entity.mime.FormBodyPart;
import ch.boye.httpclientandroidlib.entity.mime.HttpBrowserCompatibleMultipart;
import ch.boye.httpclientandroidlib.entity.mime.HttpMultipartMode;
import ch.boye.httpclientandroidlib.entity.mime.HttpRFC6532Multipart;
import ch.boye.httpclientandroidlib.entity.mime.HttpStrictMultipart;
import ch.boye.httpclientandroidlib.entity.mime.MultipartFormEntity;
import ch.boye.httpclientandroidlib.entity.mime.content.ByteArrayBody;
import ch.boye.httpclientandroidlib.entity.mime.content.ContentBody;
import ch.boye.httpclientandroidlib.entity.mime.content.FileBody;
import ch.boye.httpclientandroidlib.entity.mime.content.InputStreamBody;
import ch.boye.httpclientandroidlib.entity.mime.content.StringBody;
import ch.boye.httpclientandroidlib.util.Args;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class MultipartEntityBuilder {
    private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final String DEFAULT_SUBTYPE = "form-data";
    private String subType = "form-data";
    private HttpMultipartMode mode = HttpMultipartMode.STRICT;
    private String boundary = null;
    private Charset charset = null;
    private List<FormBodyPart> bodyParts = null;

    public static MultipartEntityBuilder create() {
        return new MultipartEntityBuilder();
    }

    MultipartEntityBuilder() {
    }

    public MultipartEntityBuilder setMode(HttpMultipartMode httpMultipartMode) {
        this.mode = httpMultipartMode;
        return this;
    }

    public MultipartEntityBuilder setLaxMode() {
        this.mode = HttpMultipartMode.BROWSER_COMPATIBLE;
        return this;
    }

    public MultipartEntityBuilder setStrictMode() {
        this.mode = HttpMultipartMode.STRICT;
        return this;
    }

    public MultipartEntityBuilder setBoundary(String string) {
        this.boundary = string;
        return this;
    }

    public MultipartEntityBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    MultipartEntityBuilder addPart(FormBodyPart formBodyPart) {
        if (formBodyPart == null) {
            return this;
        }
        if (this.bodyParts == null) {
            this.bodyParts = new ArrayList<FormBodyPart>();
        }
        this.bodyParts.add(formBodyPart);
        return this;
    }

    public MultipartEntityBuilder addPart(String string, ContentBody contentBody) {
        Args.notNull(string, "Name");
        Args.notNull(contentBody, "Content body");
        return this.addPart(new FormBodyPart(string, contentBody));
    }

    public MultipartEntityBuilder addTextBody(String string, String string2, ContentType contentType) {
        return this.addPart(string, new StringBody(string2, contentType));
    }

    public MultipartEntityBuilder addTextBody(String string, String string2) {
        return this.addTextBody(string, string2, ContentType.DEFAULT_TEXT);
    }

    public MultipartEntityBuilder addBinaryBody(String string, byte[] byArray, ContentType contentType, String string2) {
        return this.addPart(string, new ByteArrayBody(byArray, contentType, string2));
    }

    public MultipartEntityBuilder addBinaryBody(String string, byte[] byArray) {
        return this.addBinaryBody(string, byArray, ContentType.DEFAULT_BINARY, null);
    }

    public MultipartEntityBuilder addBinaryBody(String string, File file, ContentType contentType, String string2) {
        return this.addPart(string, new FileBody(file, contentType, string2));
    }

    public MultipartEntityBuilder addBinaryBody(String string, File file) {
        return this.addBinaryBody(string, file, ContentType.DEFAULT_BINARY, file != null ? file.getName() : null);
    }

    public MultipartEntityBuilder addBinaryBody(String string, InputStream inputStream, ContentType contentType, String string2) {
        return this.addPart(string, new InputStreamBody(inputStream, contentType, string2));
    }

    public MultipartEntityBuilder addBinaryBody(String string, InputStream inputStream) {
        return this.addBinaryBody(string, inputStream, ContentType.DEFAULT_BINARY, null);
    }

    private String generateContentType(String string, Charset charset) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("multipart/form-data; boundary=");
        stringBuilder.append(string);
        if (charset != null) {
            stringBuilder.append("; charset=");
            stringBuilder.append(charset.name());
        }
        return stringBuilder.toString();
    }

    private String generateBoundary() {
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random();
        int n = random.nextInt(11) + 30;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(MULTIPART_CHARS[random.nextInt(MULTIPART_CHARS.length)]);
        }
        return stringBuilder.toString();
    }

    MultipartFormEntity buildEntity() {
        AbstractMultipartForm abstractMultipartForm;
        String string = this.subType != null ? this.subType : DEFAULT_SUBTYPE;
        Charset charset = this.charset;
        String string2 = this.boundary != null ? this.boundary : this.generateBoundary();
        ArrayList<FormBodyPart> arrayList = this.bodyParts != null ? new ArrayList<FormBodyPart>(this.bodyParts) : Collections.emptyList();
        HttpMultipartMode httpMultipartMode = this.mode != null ? this.mode : HttpMultipartMode.STRICT;
        switch (httpMultipartMode) {
            case BROWSER_COMPATIBLE: {
                abstractMultipartForm = new HttpBrowserCompatibleMultipart(string, charset, string2, arrayList);
                break;
            }
            case RFC6532: {
                abstractMultipartForm = new HttpRFC6532Multipart(string, charset, string2, arrayList);
                break;
            }
            default: {
                abstractMultipartForm = new HttpStrictMultipart(string, charset, string2, arrayList);
            }
        }
        return new MultipartFormEntity(abstractMultipartForm, this.generateContentType(string2, charset), abstractMultipartForm.getTotalLength());
    }

    public HttpEntity build() {
        return this.buildEntity();
    }
}

