/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.annotation.GuardedBy;
import ch.boye.httpclientandroidlib.annotation.ThreadSafe;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Formatter;
import java.util.Locale;

@ThreadSafe
class BasicIdGenerator {
    private final String hostname;
    private final SecureRandom rnd;
    @GuardedBy(value="this")
    private long count;

    public BasicIdGenerator() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
        }
        this.hostname = string;
        try {
            this.rnd = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error(noSuchAlgorithmException);
        }
        this.rnd.setSeed(System.currentTimeMillis());
    }

    public synchronized void generate(StringBuilder stringBuilder) {
        ++this.count;
        int n = this.rnd.nextInt();
        stringBuilder.append(System.currentTimeMillis());
        stringBuilder.append('.');
        Formatter formatter = new Formatter(stringBuilder, Locale.US);
        formatter.format("%1$016x-%2$08x", this.count, n);
        formatter.close();
        stringBuilder.append('.');
        stringBuilder.append(this.hostname);
    }

    public String generate() {
        StringBuilder stringBuilder = new StringBuilder();
        this.generate(stringBuilder);
        return stringBuilder.toString();
    }
}

