/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.LayerView;

class TextSelectionHandle
extends ImageView
implements View.OnTouchListener {
    private static final String LOGTAG = "GeckoTextSelectionHandle";
    private final HandleType mHandleType;
    private final int mWidth;
    private final int mHeight;
    private final int mShadow;
    private float mLeft;
    private float mTop;
    private boolean mIsRTL;
    private PointF mGeckoPoint;
    private float mTouchStartX;
    private float mTouchStartY;
    private int mLayerViewX;
    private int mLayerViewY;
    private RelativeLayout.LayoutParams mLayoutParams;
    private static final int IMAGE_LEVEL_LTR = 0;
    private static final int IMAGE_LEVEL_RTL = 1;

    public TextSelectionHandle(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setOnTouchListener(this);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TextSelectionHandle);
        int n = typedArray.getInt(0, 1);
        this.mHandleType = n == 1 ? HandleType.START : (n == 2 ? HandleType.MIDDLE : HandleType.END);
        this.mGeckoPoint = new PointF(0.0f, 0.0f);
        this.mWidth = this.getResources().getDimensionPixelSize(R.dimen.text_selection_handle_width);
        this.mHeight = this.getResources().getDimensionPixelSize(R.dimen.text_selection_handle_height);
        this.mShadow = this.getResources().getDimensionPixelSize(R.dimen.text_selection_handle_shadow);
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        switch (motionEvent.getActionMasked()) {
            case 0: {
                this.mTouchStartX = motionEvent.getX();
                this.mTouchStartY = motionEvent.getY();
                int[] nArray = new int[2];
                GeckoAppShell.getLayerView().getLocationOnScreen(nArray);
                this.mLayerViewX = nArray[0];
                this.mLayerViewY = nArray[1];
                break;
            }
            case 1: {
                this.mTouchStartX = 0.0f;
                this.mTouchStartY = 0.0f;
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("handleType", (Object)this.mHandleType.toString());
                }
                catch (Exception exception) {
                    Log.e((String)LOGTAG, (String)"Error building JSON arguments for TextSelection:Position");
                }
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("TextSelection:Position", jSONObject.toString()));
                break;
            }
            case 2: {
                this.move(motionEvent.getRawX(), motionEvent.getRawY());
            }
        }
        return true;
    }

    private void move(float f, float f2) {
        this.mLeft = f - (float)this.mLayerViewX - this.mTouchStartX;
        this.mTop = f2 - (float)this.mLayerViewY - this.mTouchStartY;
        LayerView layerView = GeckoAppShell.getLayerView();
        if (layerView == null) {
            Log.e((String)LOGTAG, (String)"Can't move selection because layerView is null");
            return;
        }
        float f3 = this.mLeft + this.adjustLeftForHandle();
        PointF pointF = new PointF(f3, this.mTop);
        pointF = layerView.convertViewPointToLayerPoint(pointF);
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("handleType", (Object)this.mHandleType.toString());
            jSONObject.put("x", (int)pointF.x);
            jSONObject.put("y", (int)pointF.y);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error building JSON arguments for TextSelection:Move");
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("TextSelection:Move", jSONObject.toString()));
        if (this.mHandleType != HandleType.MIDDLE) {
            this.setLayoutPosition();
        }
    }

    void positionFromGecko(int n, int n2, boolean bl) {
        LayerView layerView = GeckoAppShell.getLayerView();
        if (layerView == null) {
            Log.e((String)LOGTAG, (String)"Can't position handle because layerView is null");
            return;
        }
        this.mGeckoPoint = new PointF((float)n, (float)n2);
        if (this.mIsRTL != bl) {
            this.mIsRTL = bl;
            this.setImageLevel(this.mIsRTL ? 1 : 0);
        }
        ImmutableViewportMetrics immutableViewportMetrics = layerView.getViewportMetrics();
        PointF pointF = immutableViewportMetrics.getMarginOffset();
        this.repositionWithViewport(immutableViewportMetrics.viewportRectLeft - pointF.x, immutableViewportMetrics.viewportRectTop - pointF.y, immutableViewportMetrics.zoomFactor);
    }

    void repositionWithViewport(float f, float f2, float f3) {
        PointF pointF = new PointF(this.mGeckoPoint.x * f3 - f, this.mGeckoPoint.y * f3 - f2);
        this.mLeft = pointF.x - this.adjustLeftForHandle();
        this.mTop = pointF.y;
        this.setLayoutPosition();
    }

    private float adjustLeftForHandle() {
        if (this.mHandleType == HandleType.START) {
            return this.mIsRTL ? (float)this.mShadow : (float)(this.mWidth - this.mShadow);
        }
        if (this.mHandleType == HandleType.MIDDLE) {
            return this.mWidth / 2;
        }
        return this.mIsRTL ? (float)(this.mWidth - this.mShadow) : (float)this.mShadow;
    }

    private void setLayoutPosition() {
        if (this.mLayoutParams == null) {
            this.mLayoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
            this.mLayoutParams.rightMargin = 0 - this.mWidth;
            this.mLayoutParams.bottomMargin = 0 - this.mHeight;
        }
        this.mLayoutParams.leftMargin = (int)this.mLeft;
        this.mLayoutParams.topMargin = (int)this.mTop;
        this.setLayoutParams((ViewGroup.LayoutParams)this.mLayoutParams);
    }

    private static enum HandleType {
        START,
        MIDDLE,
        END;

    }
}

