/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import org.mozilla.gecko.GeckoSharedPrefs;

class PanelAuthCache {
    private static final String LOGTAG = "GeckoPanelAuthCache";
    private static final String PREFS_PANEL_AUTH_PREFIX = "home_panels_auth_";
    private final Context mContext;
    private SharedPrefsListener mSharedPrefsListener;
    private OnChangeListener mChangeListener;

    public PanelAuthCache(Context context) {
        this.mContext = context;
    }

    private SharedPreferences getSharedPreferences() {
        return GeckoSharedPrefs.forProfile(this.mContext);
    }

    private String getPanelAuthKey(String string2) {
        return PREFS_PANEL_AUTH_PREFIX + string2;
    }

    public boolean isAuthenticated(String string2) {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        return sharedPreferences.getBoolean(this.getPanelAuthKey(string2), false);
    }

    public void setOnChangeListener(OnChangeListener onChangeListener) {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        if (this.mChangeListener != null) {
            sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this.mSharedPrefsListener);
            this.mSharedPrefsListener = null;
        }
        this.mChangeListener = onChangeListener;
        if (this.mChangeListener != null) {
            this.mSharedPrefsListener = new SharedPrefsListener();
            sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this.mSharedPrefsListener);
        }
    }

    private class SharedPrefsListener
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        private SharedPrefsListener() {
        }

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string2) {
            if (string2.startsWith(PanelAuthCache.PREFS_PANEL_AUTH_PREFIX)) {
                String string3 = string2.substring(PanelAuthCache.PREFS_PANEL_AUTH_PREFIX.length());
                boolean bl = sharedPreferences.getBoolean(string2, false);
                Log.d((String)PanelAuthCache.LOGTAG, (String)("Auth state changed: panelId=" + string3 + ", isAuthenticated=" + bl));
                PanelAuthCache.this.mChangeListener.onChange(string3, bl);
            }
        }
    }

    public static interface OnChangeListener {
        public void onChange(String var1, boolean var2);
    }
}

