/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.preference.Preference;
import android.view.View;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.preferences.CustomListCategory;

public abstract class CustomListPreference
extends Preference
implements View.OnLongClickListener {
    protected String LOGTAG = "CustomListPreference";
    public static final int INDEX_SET_DEFAULT_BUTTON = 0;
    private String[] mDialogItems;
    protected AlertDialog mDialog;
    protected final String LABEL_IS_DEFAULT;
    protected final String LABEL_SET_AS_DEFAULT;
    protected final String LABEL_REMOVE;
    protected boolean mIsDefault;
    protected final CustomListCategory mParentCategory;

    public CustomListPreference(Context context, CustomListCategory customListCategory) {
        super(context);
        this.mParentCategory = customListCategory;
        this.setLayoutResource(this.getPreferenceLayoutResource());
        this.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

            public boolean onPreferenceClick(Preference preference) {
                CustomListPreference customListPreference = (CustomListPreference)preference;
                customListPreference.showDialog();
                return true;
            }
        });
        Resources resources = this.getContext().getResources();
        this.LABEL_IS_DEFAULT = resources.getString(R.string.pref_default);
        this.LABEL_SET_AS_DEFAULT = resources.getString(R.string.pref_dialog_set_default);
        this.LABEL_REMOVE = resources.getString(R.string.pref_dialog_remove);
    }

    protected abstract int getPreferenceLayoutResource();

    public void setIsDefault(boolean bl) {
        this.mIsDefault = bl;
        if (bl) {
            this.setOrder(0);
            this.setSummary(this.LABEL_IS_DEFAULT);
        } else {
            this.setOrder(1);
            this.setSummary("");
        }
    }

    private String[] getCachedDialogItems() {
        if (this.mDialogItems == null) {
            this.mDialogItems = this.createDialogItems();
        }
        return this.mDialogItems;
    }

    protected abstract String[] createDialogItems();

    public void showDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setTitle((CharSequence)this.getTitle().toString());
        builder.setItems((CharSequence[])this.getCachedDialogItems(), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                CustomListPreference.this.hideDialog();
                CustomListPreference.this.onDialogIndexClicked(n);
            }
        });
        this.configureDialogBuilder(builder);
        this.mDialog = builder.create();
        this.mDialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialogInterface) {
                CustomListPreference.this.configureShownDialog();
            }
        });
        this.mDialog.show();
    }

    protected void configureDialogBuilder(AlertDialog.Builder builder) {
    }

    protected abstract void onDialogIndexClicked(int var1);

    protected void configureShownDialog() {
        TextView textView = (TextView)this.mDialog.getListView().getChildAt(0);
        if (this.mIsDefault) {
            textView.setEnabled(false);
            textView.setOnClickListener(null);
        }
    }

    public void hideDialog() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    public boolean onLongClick(View view) {
        this.showDialog();
        return true;
    }
}

