/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.crypto;

import android.content.SharedPreferences;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.CollectionKeys;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.crypto.KeyBundle;

public class PersistedCrypto5Keys {
    public static final String LOG_TAG = "PersistedC5Keys";
    public static final String CRYPTO5_KEYS_SERVER_RESPONSE_BODY = "crypto5KeysServerResponseBody";
    public static final String CRYPTO5_KEYS_LAST_MODIFIED = "crypto5KeysLastModified";
    protected SharedPreferences prefs;
    protected KeyBundle syncKeyBundle;

    public PersistedCrypto5Keys(SharedPreferences sharedPreferences, KeyBundle keyBundle) {
        if (keyBundle == null) {
            throw new IllegalArgumentException("Null syncKeyBundle passed in to PersistedCrypto5Keys constructor.");
        }
        this.prefs = sharedPreferences;
        this.syncKeyBundle = keyBundle;
    }

    public CollectionKeys keys() {
        String string2 = this.prefs.getString(CRYPTO5_KEYS_SERVER_RESPONSE_BODY, null);
        if (string2 == null) {
            return null;
        }
        try {
            CryptoRecord cryptoRecord = CryptoRecord.fromJSONRecord(string2);
            CollectionKeys collectionKeys = new CollectionKeys();
            collectionKeys.setKeyPairsFromWBO(cryptoRecord, this.syncKeyBundle);
            return collectionKeys;
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception decrypting persisted crypto/keys.", exception);
            return null;
        }
    }

    public void persistKeys(CollectionKeys collectionKeys) {
        if (collectionKeys == null) {
            Logger.debug(LOG_TAG, "Clearing persisted crypto/keys.");
            this.prefs.edit().remove(CRYPTO5_KEYS_SERVER_RESPONSE_BODY).commit();
            return;
        }
        try {
            CryptoRecord cryptoRecord = collectionKeys.asCryptoRecord();
            cryptoRecord.keyBundle = this.syncKeyBundle;
            cryptoRecord.encrypt();
            String string2 = cryptoRecord.toJSONString();
            Logger.debug(LOG_TAG, "Persisting crypto/keys.");
            this.prefs.edit().putString(CRYPTO5_KEYS_SERVER_RESPONSE_BODY, string2).commit();
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception encrypting while persisting crypto/keys.", exception);
        }
    }

    public boolean persistedKeysExist() {
        return this.lastModified() > 0L;
    }

    public long lastModified() {
        return this.prefs.getLong(CRYPTO5_KEYS_LAST_MODIFIED, -1L);
    }

    public void persistLastModified(long l) {
        if (l <= 0L) {
            Logger.debug(LOG_TAG, "Clearing persisted crypto/keys last modified timestamp.");
            this.prefs.edit().remove(CRYPTO5_KEYS_LAST_MODIFIED).commit();
            return;
        }
        Logger.debug(LOG_TAG, "Persisting crypto/keys last modified timestamp " + l + ".");
        this.prefs.edit().putLong(CRYPTO5_KEYS_LAST_MODIFIED, l).commit();
    }

    public void purge() {
        this.persistLastModified(-1L);
        this.persistKeys(null);
    }
}

