/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.jpake.stage;

import java.io.UnsupportedEncodingException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.crypto.CryptoException;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.jpake.JPakeClient;
import org.mozilla.gecko.sync.jpake.stage.JPakeStage;

public class ComputeKeyVerificationStage
extends JPakeStage {
    @Override
    public void execute(JPakeClient jPakeClient) {
        Logger.debug("SyncJPakeStage", "Computing verification to send.");
        if (jPakeClient.myKeyBundle == null) {
            Logger.error("SyncJPakeStage", "KeyBundle has not been set; aborting.");
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        try {
            jPakeClient.jOutgoing = this.computeKeyVerification(jPakeClient.myKeyBundle, jPakeClient.mySignerId);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.error("SyncJPakeStage", "Failure in key verification.", unsupportedEncodingException);
            jPakeClient.abort("jpake.error.invalid");
            return;
        }
        catch (CryptoException cryptoException) {
            Logger.error("SyncJPakeStage", "Encryption failure in key verification.", cryptoException);
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        jPakeClient.runNextStage();
    }

    public ExtendedJSONObject computeKeyVerification(KeyBundle keyBundle, String string2) throws UnsupportedEncodingException, CryptoException {
        Logger.debug("SyncJPakeStage", "Encrypting key verification value.");
        ExtendedJSONObject extendedJSONObject = JPakeClient.encryptPayload("0123456789ABCDEF", keyBundle, true);
        ExtendedJSONObject extendedJSONObject2 = new ExtendedJSONObject();
        extendedJSONObject2.put("type", string2 + "3");
        extendedJSONObject2.put("version", 3);
        extendedJSONObject2.put("payload", extendedJSONObject.object);
        return extendedJSONObject2;
    }
}

