/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.jpake.stage;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.jpake.BigIntegerHelper;
import org.mozilla.gecko.sync.jpake.Gx3OrGx4IsZeroOrOneException;
import org.mozilla.gecko.sync.jpake.IncorrectZkpException;
import org.mozilla.gecko.sync.jpake.JPakeClient;
import org.mozilla.gecko.sync.jpake.JPakeCrypto;
import org.mozilla.gecko.sync.jpake.JPakeJson;
import org.mozilla.gecko.sync.jpake.Zkp;
import org.mozilla.gecko.sync.jpake.stage.JPakeStage;

public class ComputeStepTwoStage
extends JPakeStage {
    @Override
    public void execute(JPakeClient jPakeClient) {
        ExtendedJSONObject extendedJSONObject;
        ExtendedJSONObject extendedJSONObject2;
        ExtendedJSONObject extendedJSONObject3;
        Logger.debug("SyncJPakeStage", "Computing round 2.");
        if (!jPakeClient.jIncoming.get("type").equals(jPakeClient.theirSignerId + "1")) {
            Logger.error("SyncJPakeStage", "Invalid round 1 message: " + jPakeClient.jIncoming.toJSONString());
            jPakeClient.abort("jpake.error.wrongmessage");
            return;
        }
        try {
            extendedJSONObject3 = jPakeClient.jIncoming.getObject("payload");
        }
        catch (NonObjectJSONException nonObjectJSONException) {
            Logger.error("SyncJPakeStage", "JSON object exception.", nonObjectJSONException);
            jPakeClient.abort("jpake.error.invalid");
            return;
        }
        if (extendedJSONObject3 == null) {
            Logger.error("SyncJPakeStage", "Invalid round 1 message: " + jPakeClient.jIncoming.toJSONString());
            jPakeClient.abort("jpake.error.wrongmessage");
            return;
        }
        try {
            extendedJSONObject2 = extendedJSONObject3.getObject("zkp_x1");
            extendedJSONObject = extendedJSONObject3.getObject("zkp_x2");
        }
        catch (NonObjectJSONException nonObjectJSONException) {
            jPakeClient.abort("jpake.error.invalid");
            return;
        }
        if (extendedJSONObject2 == null || extendedJSONObject == null) {
            Logger.error("SyncJPakeStage", "Invalid round 1 zkpPayload message");
            jPakeClient.abort("jpake.error.wrongmessage");
            return;
        }
        if (!jPakeClient.theirSignerId.equals(extendedJSONObject2.get("id")) || !jPakeClient.theirSignerId.equals(extendedJSONObject.get("id"))) {
            Logger.error("SyncJPakeStage", "Invalid round 1 zkpPayload message");
            jPakeClient.abort("jpake.error.wrongmessage");
            return;
        }
        jPakeClient.jParty.gx3 = new BigInteger((String)extendedJSONObject3.get("gx1"), 16);
        jPakeClient.jParty.gx4 = new BigInteger((String)extendedJSONObject3.get("gx2"), 16);
        String string2 = (String)extendedJSONObject2.get("gr");
        String string3 = (String)extendedJSONObject2.get("b");
        String string4 = (String)extendedJSONObject2.get("id");
        String string5 = (String)extendedJSONObject.get("gr");
        String string6 = (String)extendedJSONObject.get("b");
        String string7 = (String)extendedJSONObject.get("id");
        jPakeClient.jParty.zkp3 = new Zkp(new BigInteger(string2, 16), new BigInteger(string3, 16), string4);
        jPakeClient.jParty.zkp4 = new Zkp(new BigInteger(string5, 16), new BigInteger(string6, 16), string7);
        try {
            JPakeCrypto.round2(JPakeClient.secretAsBigInteger(jPakeClient.secret), jPakeClient.jParty, jPakeClient.numGen);
        }
        catch (Gx3OrGx4IsZeroOrOneException gx3OrGx4IsZeroOrOneException) {
            Logger.error("SyncJPakeStage", "gx3 and gx4 cannot equal 0 or 1.");
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        catch (IncorrectZkpException incorrectZkpException) {
            Logger.error("SyncJPakeStage", "ZKP mismatch");
            jPakeClient.abort("jpake.error.wrongmessage");
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.error("SyncJPakeStage", "NoSuchAlgorithmException", noSuchAlgorithmException);
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.error("SyncJPakeStage", "UnsupportedEncodingException", unsupportedEncodingException);
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        Zkp zkp = jPakeClient.jParty.thisZkpA;
        ExtendedJSONObject extendedJSONObject4 = new ExtendedJSONObject();
        ExtendedJSONObject extendedJSONObject5 = JPakeJson.makeJZkp(zkp.gr, zkp.b, zkp.id);
        extendedJSONObject4.put("A", BigIntegerHelper.toEvenLengthHex(jPakeClient.jParty.thisA));
        extendedJSONObject4.put("zkp_A", extendedJSONObject5);
        jPakeClient.jOutgoing = new ExtendedJSONObject();
        jPakeClient.jOutgoing.put("type", jPakeClient.mySignerId + "2");
        jPakeClient.jOutgoing.put("version", 3);
        jPakeClient.jOutgoing.put("payload", extendedJSONObject4);
        jPakeClient.runNextStage();
    }
}

