/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.android.CachedSQLiteOpenHelper;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.domain.ClientRecord;

public class ClientsDatabase
extends CachedSQLiteOpenHelper {
    public static final String LOG_TAG = "ClientsDatabase";
    protected static final String DB_NAME = "clients_database";
    protected static final int SCHEMA_VERSION = 2;
    public static final String TBL_CLIENTS = "clients";
    public static final String COL_ACCOUNT_GUID = "guid";
    public static final String COL_PROFILE = "profile";
    public static final String COL_NAME = "name";
    public static final String COL_TYPE = "device_type";
    public static final String[] TBL_CLIENTS_COLUMNS = new String[]{"guid", "profile", "name", "device_type"};
    public static final String TBL_CLIENTS_KEY = "guid = ? AND profile = ?";
    public static final String TBL_COMMANDS = "commands";
    public static final String COL_COMMAND = "command";
    public static final String COL_ARGS = "args";
    public static final String[] TBL_COMMANDS_COLUMNS = new String[]{"guid", "command", "args"};
    public static final String TBL_COMMANDS_KEY = "guid = ? AND command = ? AND args = ?";
    public static final String TBL_COMMANDS_GUID_QUERY = "guid = ? ";
    private final RepoUtils.QueryHelper queryHelper;

    public ClientsDatabase(Context context) {
        super(context, DB_NAME, null, 2);
        this.queryHelper = new RepoUtils.QueryHelper(context, null, LOG_TAG);
        Logger.debug(LOG_TAG, "ClientsDatabase instantiated.");
    }

    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        Logger.debug(LOG_TAG, "ClientsDatabase.onCreate().");
        ClientsDatabase.createClientsTable(sQLiteDatabase);
        ClientsDatabase.createCommandsTable(sQLiteDatabase);
    }

    public static void createClientsTable(SQLiteDatabase sQLiteDatabase) {
        Logger.debug(LOG_TAG, "ClientsDatabase.createClientsTable().");
        String string2 = "CREATE TABLE clients (guid TEXT, profile TEXT, name TEXT, device_type TEXT, PRIMARY KEY (guid, profile))";
        sQLiteDatabase.execSQL(string2);
    }

    public static void createCommandsTable(SQLiteDatabase sQLiteDatabase) {
        Logger.debug(LOG_TAG, "ClientsDatabase.createCommandsTable().");
        String string2 = "CREATE TABLE commands (guid TEXT, command TEXT, args TEXT, PRIMARY KEY (guid, command, args), FOREIGN KEY (guid) REFERENCES clients (guid))";
        sQLiteDatabase.execSQL(string2);
    }

    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        Logger.debug(LOG_TAG, "ClientsDatabase.onUpgrade().");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS clients");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS commands");
        this.onCreate(sQLiteDatabase);
    }

    public void wipeDB() {
        SQLiteDatabase sQLiteDatabase = this.getCachedWritableDatabase();
        this.onUpgrade(sQLiteDatabase, 2, 2);
    }

    public void wipeClientsTable() {
        SQLiteDatabase sQLiteDatabase = this.getCachedWritableDatabase();
        sQLiteDatabase.execSQL("DELETE FROM clients");
    }

    public void wipeCommandsTable() {
        SQLiteDatabase sQLiteDatabase = this.getCachedWritableDatabase();
        sQLiteDatabase.execSQL("DELETE FROM commands");
    }

    public void store(String string2, ClientRecord clientRecord) {
        SQLiteDatabase sQLiteDatabase = this.getCachedWritableDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put(COL_ACCOUNT_GUID, clientRecord.guid);
        contentValues.put(COL_PROFILE, string2);
        contentValues.put(COL_NAME, clientRecord.name);
        contentValues.put(COL_TYPE, clientRecord.type);
        String[] stringArray = new String[]{clientRecord.guid, string2};
        int n = sQLiteDatabase.update(TBL_CLIENTS, contentValues, TBL_CLIENTS_KEY, stringArray);
        if (n >= 1) {
            Logger.debug(LOG_TAG, "Replaced client record for row with accountGUID " + clientRecord.guid);
        } else {
            long l = sQLiteDatabase.insert(TBL_CLIENTS, null, contentValues);
            Logger.debug(LOG_TAG, "Inserted client record into row: " + l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String string2, String string3, String string4) throws NullCursorException {
        if (Logger.LOG_PERSONAL_INFORMATION) {
            Logger.pii(LOG_TAG, "Storing command " + string3 + " with args " + string4);
        } else {
            Logger.trace(LOG_TAG, "Storing command " + string3 + ".");
        }
        SQLiteDatabase sQLiteDatabase = this.getCachedWritableDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put(COL_ACCOUNT_GUID, string2);
        contentValues.put(COL_COMMAND, string3);
        if (string4 == null) {
            contentValues.put(COL_ARGS, "[]");
        } else {
            contentValues.put(COL_ARGS, string4);
        }
        try (Cursor cursor = this.fetchSpecificCommand(string2, string3, string4);){
            if (cursor.moveToFirst()) {
                Logger.debug(LOG_TAG, "Command already exists in database.");
                return;
            }
        }
        long l = sQLiteDatabase.insert(TBL_COMMANDS, null, contentValues);
        Logger.debug(LOG_TAG, "Inserted command into row: " + l);
    }

    public Cursor fetchClientsCursor(String string2, String string3) throws NullCursorException {
        String[] stringArray = new String[]{string2, string3};
        SQLiteDatabase sQLiteDatabase = this.getCachedReadableDatabase();
        return this.queryHelper.safeQuery(sQLiteDatabase, ".fetchClientsCursor", TBL_CLIENTS, TBL_CLIENTS_COLUMNS, TBL_CLIENTS_KEY, stringArray);
    }

    public Cursor fetchSpecificCommand(String string2, String string3, String string4) throws NullCursorException {
        String[] stringArray = new String[]{string2, string3, string4};
        SQLiteDatabase sQLiteDatabase = this.getCachedReadableDatabase();
        return this.queryHelper.safeQuery(sQLiteDatabase, ".fetchSpecificCommand", TBL_COMMANDS, TBL_COMMANDS_COLUMNS, TBL_COMMANDS_KEY, stringArray);
    }

    public Cursor fetchCommandsForClient(String string2) throws NullCursorException {
        String[] stringArray = new String[]{string2};
        SQLiteDatabase sQLiteDatabase = this.getCachedReadableDatabase();
        return this.queryHelper.safeQuery(sQLiteDatabase, ".fetchCommandsForClient", TBL_COMMANDS, TBL_COMMANDS_COLUMNS, TBL_COMMANDS_GUID_QUERY, stringArray);
    }

    public Cursor fetchAllClients() throws NullCursorException {
        SQLiteDatabase sQLiteDatabase = this.getCachedReadableDatabase();
        return this.queryHelper.safeQuery(sQLiteDatabase, ".fetchAllClients", TBL_CLIENTS, TBL_CLIENTS_COLUMNS, null, null);
    }

    public Cursor fetchAllCommands() throws NullCursorException {
        SQLiteDatabase sQLiteDatabase = this.getCachedReadableDatabase();
        return this.queryHelper.safeQuery(sQLiteDatabase, ".fetchAllCommands", TBL_COMMANDS, TBL_COMMANDS_COLUMNS, null, null);
    }

    public void deleteClient(String string2, String string3) {
        String[] stringArray = new String[]{string2, string3};
        SQLiteDatabase sQLiteDatabase = this.getCachedWritableDatabase();
        sQLiteDatabase.delete(TBL_CLIENTS, TBL_CLIENTS_KEY, stringArray);
    }
}

