/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.delegates;

import java.util.concurrent.ExecutorService;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionStoreDelegate;

public class DeferredRepositorySessionStoreDelegate
implements RepositorySessionStoreDelegate {
    protected final RepositorySessionStoreDelegate inner;
    protected final ExecutorService executor;

    public DeferredRepositorySessionStoreDelegate(RepositorySessionStoreDelegate repositorySessionStoreDelegate, ExecutorService executorService) {
        this.inner = repositorySessionStoreDelegate;
        this.executor = executorService;
    }

    @Override
    public void onRecordStoreSucceeded(final String string2) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DeferredRepositorySessionStoreDelegate.this.inner.onRecordStoreSucceeded(string2);
            }
        });
    }

    @Override
    public void onRecordStoreFailed(final Exception exception, final String string2) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DeferredRepositorySessionStoreDelegate.this.inner.onRecordStoreFailed(exception, string2);
            }
        });
    }

    @Override
    public RepositorySessionStoreDelegate deferredStoreDelegate(ExecutorService executorService) {
        if (executorService == this.executor) {
            return this;
        }
        throw new IllegalArgumentException("Can't re-defer this delegate.");
    }

    @Override
    public void onStoreCompleted(final long l) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DeferredRepositorySessionStoreDelegate.this.inner.onStoreCompleted(l);
            }
        });
    }
}

