/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.GridView;
import android.widget.ListAdapter;
import java.util.ArrayList;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.tabs.TabsLayoutAdapter;
import org.mozilla.gecko.tabs.TabsLayoutItemView;
import org.mozilla.gecko.tabs.TabsPanel;

class TabsGridLayout
extends GridView
implements TabsPanel.TabsLayout,
Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "Gecko" + TabsGridLayout.class.getSimpleName();
    private final Context mContext;
    private TabsPanel mTabsPanel;
    private final boolean mIsPrivate;
    private final TabsLayoutAdapter mTabsAdapter;

    public TabsGridLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet, R.attr.tabGridLayoutViewStyle);
        this.mContext = context;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TabsTray);
        this.mIsPrivate = typedArray.getInt(0, 0) == 1;
        typedArray.recycle();
        this.mTabsAdapter = new TabsGridLayoutAdapter(this.mContext);
        this.setAdapter((ListAdapter)this.mTabsAdapter);
        this.setRecyclerListener(new AbsListView.RecyclerListener(){

            public void onMovedToScrapHeap(View view) {
                TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)view;
                tabsLayoutItemView.setThumbnail(null);
            }
        });
    }

    @Override
    public void setTabsPanel(TabsPanel tabsPanel) {
        this.mTabsPanel = tabsPanel;
    }

    @Override
    public void show() {
        this.setVisibility(0);
        Tabs.getInstance().refreshThumbnails();
        Tabs.registerOnTabsChangedListener(this);
        this.refreshTabsData();
    }

    @Override
    public void hide() {
        this.setVisibility(8);
        Tabs.unregisterOnTabsChangedListener(this);
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Tab:Screenshot:Cancel", ""));
        this.mTabsAdapter.clear();
    }

    @Override
    public boolean shouldExpand() {
        return true;
    }

    private void autoHidePanel() {
        this.mTabsPanel.autoHidePanel();
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case ADDED: {
                this.refreshTabsData();
                break;
            }
            case CLOSED: {
                if (tab.isPrivate() != this.mIsPrivate || this.mTabsAdapter.getCount() <= 0 || !this.mTabsAdapter.removeTab(tab)) break;
                int n = this.mTabsAdapter.getPositionForTab(Tabs.getInstance().getSelectedTab());
                this.updateSelectedStyle(n);
                break;
            }
            case SELECTED: {
                this.updateSelectedPosition();
            }
            case UNSELECTED: 
            case THUMBNAIL: 
            case TITLE: 
            case RECORDING_CHANGE: {
                View view = this.getChildAt(this.mTabsAdapter.getPositionForTab(tab) - this.getFirstVisiblePosition());
                if (view == null) {
                    return;
                }
                ((TabsLayoutItemView)view).assignValues(tab);
            }
        }
    }

    private void updateSelectedPosition() {
        int n = this.mTabsAdapter.getPositionForTab(Tabs.getInstance().getSelectedTab());
        this.updateSelectedStyle(n);
        if (n != -1) {
            this.setSelection(n);
        }
    }

    private void updateSelectedStyle(int n) {
        for (int i = 0; i < this.mTabsAdapter.getCount(); ++i) {
            this.setItemChecked(i, i == n);
        }
    }

    private void refreshTabsData() {
        ArrayList<Tab> arrayList = new ArrayList<Tab>();
        Iterable<Tab> iterable = Tabs.getInstance().getTabsInOrder();
        for (Tab tab : iterable) {
            if (tab.isPrivate() != this.mIsPrivate) continue;
            arrayList.add(tab);
        }
        this.mTabsAdapter.setTabs(arrayList);
        this.updateSelectedPosition();
    }

    private void resetTransforms(View view) {
        ViewHelper.setAlpha(view, 1.0f);
        ViewHelper.setTranslationX(view, 0.0f);
    }

    @Override
    public void closeAll() {
        this.autoHidePanel();
        if (this.getChildCount() == 0) {
            return;
        }
        Iterable<Tab> iterable = Tabs.getInstance().getTabsInOrder();
        for (Tab tab : iterable) {
            if (this.mIsPrivate && !tab.isPrivate()) continue;
            Tabs.getInstance().closeTab(tab, false);
        }
    }

    private class TabsGridLayoutAdapter
    extends TabsLayoutAdapter {
        private final View.OnClickListener mCloseClickListener;
        private final View.OnClickListener mSelectClickListener;

        public TabsGridLayoutAdapter(Context context) {
            super(context);
            this.mCloseClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)((Object)view.getTag());
                    Tab tab = Tabs.getInstance().getTab(tabsLayoutItemView.getTabId());
                    Tabs.getInstance().closeTab(tab);
                }
            };
            this.mSelectClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)view;
                    Tabs.getInstance().selectTab(tabsLayoutItemView.getTabId());
                    TabsGridLayout.this.autoHidePanel();
                }
            };
        }

        @Override
        TabsLayoutItemView newView(int n, ViewGroup viewGroup) {
            TabsLayoutItemView tabsLayoutItemView = super.newView(n, viewGroup);
            tabsLayoutItemView.setOnClickListener(this.mSelectClickListener);
            tabsLayoutItemView.setCloseOnClickListener(this.mCloseClickListener);
            return tabsLayoutItemView;
        }

        @Override
        public void bindView(TabsLayoutItemView tabsLayoutItemView, Tab tab) {
            super.bindView(tabsLayoutItemView, tab);
            TabsGridLayout.this.resetTransforms((View)tabsLayoutItemView);
        }
    }
}

