/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.tabs.TabsLayoutItemView;

public class TabsLayoutAdapter
extends BaseAdapter {
    public static final String LOGTAG = "Gecko" + TabsLayoutAdapter.class.getSimpleName();
    private final Context mContext;
    private ArrayList<Tab> mTabs;
    private final LayoutInflater mInflater;

    public TabsLayoutAdapter(Context context) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
    }

    final void setTabs(ArrayList<Tab> arrayList) {
        this.mTabs = arrayList;
        this.notifyDataSetChanged();
    }

    final boolean removeTab(Tab tab) {
        boolean bl = this.mTabs.remove(tab);
        if (bl) {
            this.notifyDataSetChanged();
        }
        return bl;
    }

    final void clear() {
        this.mTabs = null;
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mTabs == null ? 0 : this.mTabs.size();
    }

    public Tab getItem(int n) {
        return this.mTabs.get(n);
    }

    public long getItemId(int n) {
        return n;
    }

    final int getPositionForTab(Tab tab) {
        if (this.mTabs == null || tab == null) {
            return -1;
        }
        return this.mTabs.indexOf(tab);
    }

    public final TabsLayoutItemView getView(int n, View view, ViewGroup viewGroup) {
        TabsLayoutItemView tabsLayoutItemView = view == null ? this.newView(n, viewGroup) : (TabsLayoutItemView)view;
        Tab tab = this.mTabs.get(n);
        this.bindView(tabsLayoutItemView, tab);
        return tabsLayoutItemView;
    }

    TabsLayoutItemView newView(int n, ViewGroup viewGroup) {
        return (TabsLayoutItemView)this.mInflater.inflate(R.layout.tabs_layout_item_view, viewGroup, false);
    }

    void bindView(TabsLayoutItemView tabsLayoutItemView, Tab tab) {
        tabsLayoutItemView.assignValues(tab);
    }
}

