/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ForegroundColorSpan;
import android.text.style.URLSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.prompts.PromptInput;
import org.mozilla.gecko.widget.Divider;

public class DoorHanger
extends LinearLayout {
    private static final String LOGTAG = "GeckoDoorHanger";
    private static int sInputPadding = -1;
    private static int sSpinnerTextColor = -1;
    private static int sSpinnerTextSize = -1;
    private static final LinearLayout.LayoutParams sButtonParams = new LinearLayout.LayoutParams(-1, -1, 1.0f);
    private final TextView mTextView;
    private final ImageView mIcon;
    private final LinearLayout mChoicesLayout;
    private final View mDivider;
    private final int mTabId;
    private final String mValue;
    private final Resources mResources;
    private List<PromptInput> mInputs;
    private CheckBox mCheckBox;
    private int mPersistence;
    private boolean mPersistWhileVisible;
    private long mTimeout;
    private int mDividerColor;

    public DoorHanger(Context context, Theme theme) {
        this(context, 0, null, theme);
    }

    public DoorHanger(Context context, int n, String string2) {
        this(context, n, string2, Theme.LIGHT);
    }

    private DoorHanger(Context context, int n, String string2, Theme theme) {
        super(context);
        this.mTabId = n;
        this.mValue = string2;
        this.mResources = this.getResources();
        if (sInputPadding == -1) {
            sInputPadding = this.mResources.getDimensionPixelSize(R.dimen.doorhanger_padding);
        }
        if (sSpinnerTextColor == -1) {
            sSpinnerTextColor = this.mResources.getColor(R.color.text_color_primary_disable_only);
        }
        if (sSpinnerTextSize == -1) {
            sSpinnerTextSize = this.mResources.getDimensionPixelSize(R.dimen.doorhanger_spinner_textsize);
        }
        this.setOrientation(1);
        LayoutInflater.from((Context)context).inflate(R.layout.doorhanger, (ViewGroup)this);
        this.mTextView = (TextView)this.findViewById(R.id.doorhanger_title);
        this.mIcon = (ImageView)this.findViewById(R.id.doorhanger_icon);
        this.mChoicesLayout = (LinearLayout)this.findViewById(R.id.doorhanger_choices);
        this.mDivider = this.findViewById(R.id.divider_doorhanger);
        this.setTheme(theme);
    }

    private void setTheme(Theme theme) {
        if (theme == Theme.LIGHT) {
            this.mDividerColor = this.mResources.getColor(R.color.divider_light);
        } else if (theme == Theme.DARK) {
            this.mDividerColor = this.mResources.getColor(R.color.divider_dark);
            this.setBackgroundColor(this.mResources.getColor(R.color.doorhanger_background_dark));
            this.mTextView.setTextAppearance(this.getContext(), R.style.TextAppearance_Widget_DoorHanger_Small);
        }
    }

    public int getTabId() {
        return this.mTabId;
    }

    public String getValue() {
        return this.mValue;
    }

    public List<PromptInput> getInputs() {
        return this.mInputs;
    }

    public CheckBox getCheckBox() {
        return this.mCheckBox;
    }

    public void showDivider() {
        this.mDivider.setVisibility(0);
    }

    public void hideDivider() {
        this.mDivider.setVisibility(8);
    }

    public void setMessage(String string2) {
        this.mTextView.setText((CharSequence)string2);
    }

    public void setIcon(int n) {
        this.mIcon.setImageResource(n);
        this.mIcon.setVisibility(0);
    }

    public void addLink(String string2, String string3, String string4) {
        String string5 = this.mTextView.getText().toString();
        SpannableString spannableString = new SpannableString((CharSequence)(string5 + string4 + string2));
        URLSpan uRLSpan = new URLSpan(string3){

            public void onClick(View view) {
                Tabs.getInstance().loadUrlInTab(this.getURL());
            }
        };
        ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(this.mTextView.getCurrentTextColor());
        spannableString.setSpan((Object)foregroundColorSpan, 0, string5.length(), 0);
        spannableString.setSpan((Object)uRLSpan, string5.length() + 1, spannableString.length(), 0);
        this.mTextView.setText((CharSequence)spannableString);
        this.mTextView.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public void addButton(String string2, final String string3, final OnButtonClickListener onButtonClickListener) {
        Button button = (Button)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.doorhanger_button, null);
        button.setText((CharSequence)string2);
        button.setTag((Object)string3);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                onButtonClickListener.onButtonClick(DoorHanger.this, string3);
            }
        });
        if (this.mChoicesLayout.getChildCount() == 0) {
            this.mChoicesLayout.setVisibility(0);
            View view = this.findViewById(R.id.divider_choices);
            view.setVisibility(0);
            view.setBackgroundColor(this.mDividerColor);
        } else {
            Divider divider = new Divider(this.getContext(), null);
            divider.setOrientation(Divider.Orientation.VERTICAL);
            divider.setBackgroundColor(this.mDividerColor);
            this.mChoicesLayout.addView((View)divider);
        }
        this.mChoicesLayout.addView((View)button, (ViewGroup.LayoutParams)sButtonParams);
    }

    public void setOptions(JSONObject jSONObject) {
        String string2;
        Object object;
        JSONObject jSONObject2;
        int n = jSONObject.optInt("persistence");
        if (n > 0) {
            this.mPersistence = n;
        }
        this.mPersistWhileVisible = jSONObject.optBoolean("persistWhileVisible");
        long l = jSONObject.optLong("timeout");
        if (l > 0L) {
            this.mTimeout = l;
        }
        if ((jSONObject2 = jSONObject.optJSONObject("link")) != null) {
            try {
                object = jSONObject2.getString("label");
                string2 = jSONObject2.getString("url");
                this.addLink((String)object, string2, " ");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if ((object = jSONObject.optJSONArray("inputs")) != null) {
            this.mInputs = new ArrayList<PromptInput>();
            string2 = (ViewGroup)this.findViewById(R.id.doorhanger_inputs);
            string2.setVisibility(0);
            for (int i = 0; i < object.length(); ++i) {
                try {
                    PromptInput promptInput = PromptInput.getInput(object.getJSONObject(i));
                    this.mInputs.add(promptInput);
                    View view = promptInput.getView(this.getContext());
                    this.styleInput(promptInput, view);
                    string2.addView(view);
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = jSONObject.optString("checkbox")))) {
            this.mCheckBox = (CheckBox)this.findViewById(R.id.doorhanger_checkbox);
            this.mCheckBox.setText((CharSequence)string2);
            this.mCheckBox.setVisibility(0);
        }
    }

    private void styleInput(PromptInput promptInput, View view) {
        if (promptInput instanceof PromptInput.MenulistInput) {
            this.styleSpinner(promptInput, view);
        } else {
            view.setPadding(0, sInputPadding, 0, sInputPadding);
        }
    }

    private void styleSpinner(PromptInput promptInput, View view) {
        PromptInput.MenulistInput menulistInput = (PromptInput.MenulistInput)promptInput;
        Spinner spinner = menulistInput.spinner;
        SpinnerAdapter spinnerAdapter = spinner.getAdapter();
        View view2 = spinnerAdapter.getView(0, null, (ViewGroup)spinner);
        int n = 0;
        if (view2 != null) {
            n = view2.getPaddingLeft();
        }
        Rect rect = new Rect();
        spinner.getBackground().getPadding(rect);
        view.setPadding(sInputPadding - rect.left - n, 0, rect.right, sInputPadding);
        if (menulistInput.textView != null) {
            menulistInput.textView.setTextColor(sSpinnerTextColor);
            menulistInput.textView.setTextSize(sSpinnerTextSize);
            menulistInput.textView.setPadding(rect.left + n, 0, 0, 0);
        }
    }

    public boolean shouldRemove(boolean bl) {
        if (this.mPersistWhileVisible && bl) {
            if (this.mPersistence != 0) {
                --this.mPersistence;
            }
            return false;
        }
        if (this.mPersistence != 0) {
            --this.mPersistence;
            return false;
        }
        return System.currentTimeMillis() > this.mTimeout;
    }

    public static interface OnButtonClickListener {
        public void onButtonClick(DoorHanger var1, String var2);
    }

    public static enum Theme {
        LIGHT,
        DARK;

    }
}

