/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport.upload;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.IBinder;
import org.mozilla.gecko.background.BackgroundService;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.healthreport.HealthReportConstants;
import org.mozilla.gecko.background.healthreport.upload.AndroidSubmissionClient;
import org.mozilla.gecko.background.healthreport.upload.ObsoleteDocumentTracker;
import org.mozilla.gecko.background.healthreport.upload.SubmissionPolicy;

public class HealthReportUploadService
extends BackgroundService {
    public static final String LOG_TAG = HealthReportUploadService.class.getSimpleName();
    public static final String WORKER_THREAD_NAME = LOG_TAG + "Worker";

    public HealthReportUploadService() {
        super(WORKER_THREAD_NAME);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    protected SharedPreferences getSharedPreferences() {
        return this.getSharedPreferences("background", 0);
    }

    public void onHandleIntent(Intent intent) {
        Logger.setThreadLogTag("GeckoHealth");
        if (intent == null) {
            Logger.debug(LOG_TAG, "Short-circuiting on null intent.");
            return;
        }
        if (HealthReportConstants.UPLOAD_FEATURE_DISABLED) {
            Logger.debug(LOG_TAG, "Health report upload feature is compile-time disabled; not handling upload intent.");
            return;
        }
        Logger.debug(LOG_TAG, "Health report upload feature is compile-time enabled; handling upload intent.");
        String string2 = intent.getStringExtra("profileName");
        String string3 = intent.getStringExtra("profilePath");
        if (string2 == null || string3 == null) {
            Logger.warn(LOG_TAG, "Got intent without profilePath or profileName. Ignoring.");
            return;
        }
        if (!intent.hasExtra("uploadEnabled")) {
            Logger.warn(LOG_TAG, "Got intent without uploadEnabled. Ignoring.");
            return;
        }
        boolean bl = intent.getBooleanExtra("uploadEnabled", false);
        if (!this.backgroundDataIsEnabled()) {
            Logger.debug(LOG_TAG, "Background data is not enabled; skipping.");
            return;
        }
        Logger.pii(LOG_TAG, "Ticking policy for profile " + string2 + " at " + string3 + ".");
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        ObsoleteDocumentTracker obsoleteDocumentTracker = new ObsoleteDocumentTracker(sharedPreferences);
        AndroidSubmissionClient androidSubmissionClient = new AndroidSubmissionClient((Context)this, sharedPreferences, string3);
        SubmissionPolicy submissionPolicy = new SubmissionPolicy(sharedPreferences, androidSubmissionClient, obsoleteDocumentTracker, bl);
        long l = System.currentTimeMillis();
        submissionPolicy.tick(l);
    }
}

