/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.support.v4.content.AsyncTaskLoader;
import org.mozilla.gecko.home.HomeConfig;

public class HomeConfigLoader
extends AsyncTaskLoader<HomeConfig.State> {
    private final HomeConfig mConfig;
    private HomeConfig.State mConfigState;
    private final Context mContext;

    public HomeConfigLoader(Context context, HomeConfig homeConfig) {
        super(context);
        this.mContext = context;
        this.mConfig = homeConfig;
    }

    public HomeConfig.State loadInBackground() {
        return this.mConfig.load();
    }

    public void deliverResult(HomeConfig.State state) {
        if (this.isReset()) {
            this.mConfigState = null;
            return;
        }
        this.mConfigState = state;
        this.mConfig.setOnReloadListener(new ForceReloadListener());
        if (this.isStarted()) {
            super.deliverResult((Object)state);
        }
    }

    protected void onStartLoading() {
        if (this.mConfigState != null) {
            this.deliverResult(this.mConfigState);
        }
        if (this.takeContentChanged() || this.mConfigState == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    public void onCanceled(HomeConfig.State state) {
        this.mConfigState = null;
    }

    protected void onReset() {
        super.onReset();
        this.onStopLoading();
        this.mConfigState = null;
        this.mConfig.setOnReloadListener(null);
    }

    private class ForceReloadListener
    implements HomeConfig.OnReloadListener {
        private ForceReloadListener() {
        }

        @Override
        public void onReload() {
            HomeConfigLoader.this.onContentChanged();
        }
    }
}

