/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.toolbar.BrowserToolbarTabletBase;

class BrowserToolbarNewTablet
extends BrowserToolbarTabletBase {
    private static final int FORWARD_ANIMATION_DURATION = 450;
    private final int forwardButtonTranslationWidth = this.getResources().getDimensionPixelOffset(R.dimen.new_tablet_nav_button_width);

    public BrowserToolbarNewTablet(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        ViewHelper.setTranslationX((View)this.forwardButton, -this.forwardButtonTranslationWidth);
    }

    @Override
    public boolean isAnimating() {
        return false;
    }

    @Override
    protected void triggerStartEditingTransition(PropertyAnimator propertyAnimator) {
        this.showUrlEditLayout();
    }

    @Override
    protected void triggerStopEditingTransition() {
        this.hideUrlEditLayout();
    }

    @Override
    protected void animateForwardButton(BrowserToolbarTabletBase.ForwardButtonAnimation forwardButtonAnimation) {
        final boolean bl = forwardButtonAnimation == BrowserToolbarTabletBase.ForwardButtonAnimation.SHOW;
        float f = ViewHelper.getTranslationX((View)this.forwardButton);
        if (f >= 0.0f && bl || f < 0.0f && !bl) {
            return;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(this.isSwitchingTabs ? 10L : 450L);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
                if (!bl) {
                    ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarNewTablet.this.urlDisplayLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarNewTablet.this.urlEditLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    BrowserToolbarNewTablet.this.requestLayout();
                }
            }

            @Override
            public void onPropertyAnimationEnd() {
                if (bl) {
                    ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarNewTablet.this.urlDisplayLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbarNewTablet.this.forwardButtonTranslationWidth;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbarNewTablet.this.urlEditLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbarNewTablet.this.forwardButtonTranslationWidth;
                }
                BrowserToolbarNewTablet.this.urlDisplayLayout.finishForwardAnimation();
                BrowserToolbarNewTablet.this.requestLayout();
            }
        });
        this.prepareForwardAnimation(propertyAnimator, forwardButtonAnimation, this.forwardButtonTranslationWidth);
        propertyAnimator.start();
    }

    private void prepareForwardAnimation(PropertyAnimator propertyAnimator, BrowserToolbarTabletBase.ForwardButtonAnimation forwardButtonAnimation, int n) {
        if (forwardButtonAnimation == BrowserToolbarTabletBase.ForwardButtonAnimation.HIDE) {
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.TRANSLATION_X, -n);
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.ALPHA, 0.0f);
        } else {
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            propertyAnimator.attach((View)this.forwardButton, PropertyAnimator.Property.ALPHA, 1.0f);
        }
        this.urlDisplayLayout.prepareForwardAnimation(propertyAnimator, forwardButtonAnimation, n);
    }

    @Override
    public void triggerTabsPanelTransition(PropertyAnimator propertyAnimator, boolean bl) {
    }
}

