/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.annotation.TargetApi;
import android.os.Build;
import android.view.InputDevice;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;

public final class GamepadUtils {
    private static final int SONY_XPERIA_GAMEPAD_DEVICE_ID = 196611;
    private static View.OnKeyListener sClickDispatcher;
    private static float sDeadZoneThresholdOverride;

    private GamepadUtils() {
    }

    @TargetApi(value=12)
    private static boolean isGamepadKey(KeyEvent keyEvent) {
        if (Build.VERSION.SDK_INT < 12) {
            return false;
        }
        return (keyEvent.getSource() & 0x401) == 1025;
    }

    public static boolean isActionKey(KeyEvent keyEvent) {
        return GamepadUtils.isGamepadKey(keyEvent) && keyEvent.getKeyCode() == 96;
    }

    public static boolean isActionKeyDown(KeyEvent keyEvent) {
        return GamepadUtils.isActionKey(keyEvent) && keyEvent.getAction() == 0;
    }

    public static boolean isBackKey(KeyEvent keyEvent) {
        return GamepadUtils.isGamepadKey(keyEvent) && keyEvent.getKeyCode() == 97;
    }

    public static void overrideDeadZoneThreshold(float f) {
        sDeadZoneThresholdOverride = f;
    }

    public static boolean isValueInDeadZone(MotionEvent motionEvent, int n) {
        float f;
        if (sDeadZoneThresholdOverride >= 0.0f) {
            f = sDeadZoneThresholdOverride;
        } else {
            InputDevice.MotionRange motionRange = motionEvent.getDevice().getMotionRange(n);
            f = motionRange.getFlat() + motionRange.getFuzz();
        }
        float f2 = motionEvent.getAxisValue(n);
        return Math.abs(f2) < f;
    }

    public static boolean isPanningControl(MotionEvent motionEvent) {
        if (Build.VERSION.SDK_INT < 12) {
            return false;
        }
        if ((motionEvent.getSource() & 0xFF) != 16) {
            return false;
        }
        return !GamepadUtils.isValueInDeadZone(motionEvent, 0) || !GamepadUtils.isValueInDeadZone(motionEvent, 1) || !GamepadUtils.isValueInDeadZone(motionEvent, 11) || !GamepadUtils.isValueInDeadZone(motionEvent, 14);
    }

    public static View.OnKeyListener getClickDispatcher() {
        if (sClickDispatcher == null) {
            sClickDispatcher = new View.OnKeyListener(){

                public boolean onKey(View view, int n, KeyEvent keyEvent) {
                    if (GamepadUtils.isActionKeyDown(keyEvent)) {
                        return view.performClick();
                    }
                    return false;
                }
            };
        }
        return sClickDispatcher;
    }

    public static KeyEvent translateSonyXperiaGamepadKeys(int n, KeyEvent keyEvent) {
        boolean bl = GamepadUtils.areSonyXperiaGamepadKeysSwapped();
        switch (n) {
            case 4: {
                n = bl ? 96 : 97;
                break;
            }
            case 23: {
                n = bl ? 97 : 96;
                break;
            }
            default: {
                return keyEvent;
            }
        }
        return new KeyEvent(keyEvent.getAction(), n);
    }

    public static boolean isSonyXperiaGamepadKeyEvent(KeyEvent keyEvent) {
        return keyEvent.getDeviceId() == 196611 && "Sony Ericsson".equals(Build.MANUFACTURER) && ("R800".equals(Build.MODEL) || "R800i".equals(Build.MODEL));
    }

    private static boolean areSonyXperiaGamepadKeysSwapped() {
        boolean bl = false;
        int[] nArray = InputDevice.getDeviceIds();
        for (int i = 0; nArray != null && i < nArray.length; ++i) {
            KeyCharacterMap keyCharacterMap = KeyCharacterMap.load((int)nArray[i]);
            if (keyCharacterMap == null || '\u25cb' != keyCharacterMap.getDisplayLabel(23)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static {
        sDeadZoneThresholdOverride = 0.01f;
    }
}

