/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.os.Bundle;
import android.support.v7.media.MediaRouter;
import android.util.Log;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.RemoteMediaPlayer;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoMediaPlayer;
import org.mozilla.gecko.util.EventCallback;

class ChromeCast
implements GeckoMediaPlayer {
    private static final boolean SHOW_DEBUG = false;
    static final String MIRROR_RECEIVER_APP_ID = "08FF1091";
    private final Context context;
    private final MediaRouter.RouteInfo route;
    private GoogleApiClient apiClient;
    private RemoteMediaPlayer remoteMediaPlayer;
    private final boolean canMirror;
    private String mSessionId;
    private MirrorChannel mMirrorChannel;
    private boolean mApplicationStarted = false;
    private static final String LOGTAG = "GeckoChromeCast";

    public ChromeCast(Context context, MediaRouter.RouteInfo routeInfo) {
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
        if (n != 0) {
            throw new IllegalStateException("Play services are required for Chromecast support (go status code " + n + ")");
        }
        this.context = context;
        this.route = routeInfo;
        this.canMirror = routeInfo.supportsControlCategory(CastMediaControlIntent.categoryForCast((String)MIRROR_RECEIVER_APP_ID));
    }

    @Override
    public JSONObject toJSON() {
        JSONObject jSONObject = new JSONObject();
        try {
            CastDevice castDevice = CastDevice.getFromBundle((Bundle)this.route.getExtras());
            if (castDevice == null) {
                return null;
            }
            jSONObject.put("uuid", (Object)this.route.getId());
            jSONObject.put("version", (Object)castDevice.getDeviceVersion());
            jSONObject.put("friendlyName", (Object)castDevice.getFriendlyName());
            jSONObject.put("location", (Object)castDevice.getIpAddress().toString());
            jSONObject.put("modelName", (Object)castDevice.getModelName());
            jSONObject.put("mirror", this.canMirror);
            jSONObject.put("manufacturer", (Object)"Google Inc.");
        }
        catch (JSONException jSONException) {
            this.debug("Error building route", (Exception)((Object)jSONException));
        }
        return jSONObject;
    }

    @Override
    public void load(final String string2, final String string3, final String string4, final EventCallback eventCallback) {
        CastDevice castDevice = CastDevice.getFromBundle((Bundle)this.route.getExtras());
        Cast.CastOptions.Builder builder = Cast.CastOptions.builder((CastDevice)castDevice, (Cast.Listener)new Cast.Listener(){

            public void onApplicationStatusChanged() {
            }

            public void onVolumeChanged() {
            }

            public void onApplicationDisconnected(int n) {
            }
        });
        this.apiClient = new GoogleApiClient.Builder(this.context).addApi(Cast.API, (Api.ApiOptions.HasOptions)builder.build()).addConnectionCallbacks(new GoogleApiClient.ConnectionCallbacks(){

            public void onConnected(Bundle bundle) {
                if (ChromeCast.this.apiClient != null && !ChromeCast.this.apiClient.isConnected()) {
                    ChromeCast.this.debug("Connection failed");
                    eventCallback.sendError((Object)"Not connected");
                    return;
                }
                try {
                    Cast.CastApi.launchApplication(ChromeCast.this.apiClient, "CC1AD845", true).setResultCallback((ResultCallback)new VideoPlayCallback(string3, string4, string2, eventCallback));
                }
                catch (Exception exception) {
                    ChromeCast.this.debug("Failed to launch application", exception);
                }
            }

            public void onConnectionSuspended(int n) {
                ChromeCast.this.debug("suspended");
            }
        }).build();
        this.apiClient.connect();
    }

    @Override
    public void start(EventCallback eventCallback) {
        eventCallback.sendSuccess(null);
    }

    @Override
    public void stop(EventCallback eventCallback) {
        eventCallback.sendSuccess(null);
    }

    public boolean verifySession(EventCallback eventCallback) {
        String string2 = null;
        if (this.apiClient == null || !this.apiClient.isConnected()) {
            string2 = "Not connected";
        }
        if (this.mSessionId == null) {
            string2 = "No session";
        }
        if (string2 != null) {
            this.debug(string2);
            if (eventCallback != null) {
                eventCallback.sendError((Object)string2);
            }
            return false;
        }
        return true;
    }

    @Override
    public void play(final EventCallback eventCallback) {
        if (!this.verifySession(eventCallback)) {
            return;
        }
        try {
            this.remoteMediaPlayer.play(this.apiClient).setResultCallback((ResultCallback)new ResultCallback<RemoteMediaPlayer.MediaChannelResult>(){

                public void onResult(RemoteMediaPlayer.MediaChannelResult mediaChannelResult) {
                    Status status = mediaChannelResult.getStatus();
                    if (!status.isSuccess()) {
                        ChromeCast.this.debug("Unable to play: " + status.getStatusCode());
                        eventCallback.sendError((Object)status.toString());
                    } else {
                        eventCallback.sendSuccess(null);
                    }
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            eventCallback.sendError((Object)"Error playing");
        }
    }

    @Override
    public void pause(final EventCallback eventCallback) {
        if (!this.verifySession(eventCallback)) {
            return;
        }
        try {
            this.remoteMediaPlayer.pause(this.apiClient).setResultCallback((ResultCallback)new ResultCallback<RemoteMediaPlayer.MediaChannelResult>(){

                public void onResult(RemoteMediaPlayer.MediaChannelResult mediaChannelResult) {
                    Status status = mediaChannelResult.getStatus();
                    if (!status.isSuccess()) {
                        ChromeCast.this.debug("Unable to pause: " + status.getStatusCode());
                        eventCallback.sendError((Object)status.toString());
                    } else {
                        eventCallback.sendSuccess(null);
                    }
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            eventCallback.sendError((Object)"Error pausing");
        }
    }

    @Override
    public void end(final EventCallback eventCallback) {
        if (!this.verifySession(eventCallback)) {
            return;
        }
        try {
            Cast.CastApi.stopApplication(this.apiClient).setResultCallback((ResultCallback)new ResultCallback<Status>(){

                public void onResult(Status status) {
                    if (status.isSuccess()) {
                        try {
                            Cast.CastApi.removeMessageReceivedCallbacks(ChromeCast.this.apiClient, ChromeCast.this.remoteMediaPlayer.getNamespace());
                            ChromeCast.this.remoteMediaPlayer = null;
                            ChromeCast.this.mSessionId = null;
                            ChromeCast.this.apiClient.disconnect();
                            ChromeCast.this.apiClient = null;
                            if (eventCallback != null) {
                                eventCallback.sendSuccess(null);
                            }
                            return;
                        }
                        catch (Exception exception) {
                            ChromeCast.this.debug("Error ending", exception);
                        }
                    }
                    if (eventCallback != null) {
                        eventCallback.sendError((Object)status.getStatus().toString());
                    }
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            eventCallback.sendError((Object)"Error stopping");
        }
    }

    @Override
    public void message(String string2, EventCallback eventCallback) {
        if (this.mMirrorChannel != null) {
            this.mMirrorChannel.sendMessage(string2);
        }
    }

    @Override
    public void mirror(final EventCallback eventCallback) {
        CastDevice castDevice = CastDevice.getFromBundle((Bundle)this.route.getExtras());
        Cast.CastOptions.Builder builder = Cast.CastOptions.builder((CastDevice)castDevice, (Cast.Listener)new Cast.Listener(){

            public void onApplicationStatusChanged() {
            }

            public void onVolumeChanged() {
            }

            public void onApplicationDisconnected(int n) {
            }
        });
        this.apiClient = new GoogleApiClient.Builder(this.context).addApi(Cast.API, (Api.ApiOptions.HasOptions)builder.build()).addConnectionCallbacks(new GoogleApiClient.ConnectionCallbacks(){

            public void onConnected(Bundle bundle) {
                if (ChromeCast.this.apiClient == null || !ChromeCast.this.apiClient.isConnected()) {
                    return;
                }
                try {
                    Cast.CastApi.launchApplication(ChromeCast.this.apiClient, ChromeCast.MIRROR_RECEIVER_APP_ID, true).setResultCallback((ResultCallback)new MirrorCallback(eventCallback));
                }
                catch (Exception exception) {
                    ChromeCast.this.debug("Failed to launch application", exception);
                }
            }

            public void onConnectionSuspended(int n) {
                ChromeCast.this.debug("suspended");
            }
        }).build();
        this.apiClient.connect();
    }

    private void debug(String string2, Exception exception) {
    }

    private void debug(String string2) {
    }

    private class MirrorCallback
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        EventCallback callback;

        MirrorCallback(EventCallback eventCallback) {
            this.callback = eventCallback;
        }

        public void onResult(Cast.ApplicationConnectionResult applicationConnectionResult) {
            if (this.callback == null) {
                Log.e((String)ChromeCast.LOGTAG, (String)"Attempting to invoke MirrorChannel callback more than once.");
                return;
            }
            Status status = applicationConnectionResult.getStatus();
            if (status.isSuccess()) {
                ApplicationMetadata applicationMetadata = applicationConnectionResult.getApplicationMetadata();
                ChromeCast.this.mSessionId = applicationConnectionResult.getSessionId();
                String string2 = applicationConnectionResult.getApplicationStatus();
                boolean bl = applicationConnectionResult.getWasLaunched();
                ChromeCast.this.mApplicationStarted = true;
                ChromeCast.this.mMirrorChannel = new MirrorChannel();
                try {
                    Cast.CastApi.setMessageReceivedCallbacks(ChromeCast.this.apiClient, ChromeCast.this.mMirrorChannel.getNamespace(), (Cast.MessageReceivedCallback)ChromeCast.this.mMirrorChannel);
                    this.callback.sendSuccess(null);
                    this.callback = null;
                }
                catch (IOException iOException) {
                    Log.e((String)ChromeCast.LOGTAG, (String)"Exception while creating channel", (Throwable)iOException);
                }
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Casting:Mirror", ChromeCast.this.route.getId()));
            } else {
                this.callback.sendError((Object)status.toString());
                this.callback = null;
            }
        }
    }

    class MirrorChannel
    implements Cast.MessageReceivedCallback {
        MirrorChannel() {
        }

        public String getNamespace() {
            return "urn:x-cast:org.mozilla.mirror";
        }

        public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("MediaPlayer:Response", string3));
        }

        public void sendMessage(String string2) {
            if (ChromeCast.this.apiClient != null && ChromeCast.this.mMirrorChannel != null) {
                try {
                    Cast.CastApi.sendMessage(ChromeCast.this.apiClient, ChromeCast.this.mMirrorChannel.getNamespace(), string2).setResultCallback((ResultCallback)new ResultCallback<Status>(){

                        public void onResult(Status status) {
                        }
                    });
                }
                catch (Exception exception) {
                    Log.e((String)ChromeCast.LOGTAG, (String)"Exception while sending message", (Throwable)exception);
                }
            }
        }
    }

    private class VideoPlayCallback
    implements ResultCallback<Cast.ApplicationConnectionResult>,
    RemoteMediaPlayer.OnStatusUpdatedListener,
    RemoteMediaPlayer.OnMetadataUpdatedListener {
        private final String url;
        private final String type;
        private final String title;
        private final EventCallback callback;

        public VideoPlayCallback(String string2, String string3, String string4, EventCallback eventCallback) {
            this.url = string2;
            this.type = string3;
            this.title = string4;
            this.callback = eventCallback;
        }

        public void onStatusUpdated() {
            boolean bl;
            MediaStatus mediaStatus = ChromeCast.this.remoteMediaPlayer.getMediaStatus();
            boolean bl2 = bl = mediaStatus.getPlayerState() == 2;
            if (mediaStatus.getPlayerState() == 1 && mediaStatus.getIdleReason() == 1) {
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Casting:Stop", null));
            }
        }

        public void onMetadataUpdated() {
        }

        public void onResult(Cast.ApplicationConnectionResult applicationConnectionResult) {
            Status status = applicationConnectionResult.getStatus();
            ChromeCast.this.debug("ApplicationConnectionResultCallback.onResult: statusCode" + status.getStatusCode());
            if (status.isSuccess()) {
                ChromeCast.this.remoteMediaPlayer = new RemoteMediaPlayer();
                ChromeCast.this.remoteMediaPlayer.setOnStatusUpdatedListener((RemoteMediaPlayer.OnStatusUpdatedListener)this);
                ChromeCast.this.remoteMediaPlayer.setOnMetadataUpdatedListener((RemoteMediaPlayer.OnMetadataUpdatedListener)this);
                ChromeCast.this.mSessionId = applicationConnectionResult.getSessionId();
                if (!ChromeCast.this.verifySession(this.callback)) {
                    return;
                }
                try {
                    Cast.CastApi.setMessageReceivedCallbacks(ChromeCast.this.apiClient, ChromeCast.this.remoteMediaPlayer.getNamespace(), (Cast.MessageReceivedCallback)ChromeCast.this.remoteMediaPlayer);
                }
                catch (IOException iOException) {
                    ChromeCast.this.debug("Exception while creating media channel", iOException);
                }
                this.startPlayback();
            } else {
                this.callback.sendError((Object)status.toString());
            }
        }

        private void startPlayback() {
            MediaMetadata mediaMetadata = new MediaMetadata(1);
            mediaMetadata.putString("com.google.android.gms.cast.metadata.TITLE", this.title);
            MediaInfo mediaInfo = new MediaInfo.Builder(this.url).setContentType(this.type).setStreamType(1).setMetadata(mediaMetadata).build();
            try {
                ChromeCast.this.remoteMediaPlayer.load(ChromeCast.this.apiClient, mediaInfo, true).setResultCallback((ResultCallback)new ResultCallback<RemoteMediaPlayer.MediaChannelResult>(){

                    public void onResult(RemoteMediaPlayer.MediaChannelResult mediaChannelResult) {
                        if (mediaChannelResult.getStatus().isSuccess()) {
                            VideoPlayCallback.this.callback.sendSuccess(null);
                            ChromeCast.this.debug("Media loaded successfully");
                            return;
                        }
                        ChromeCast.this.debug("Media load failed " + mediaChannelResult.getStatus());
                        VideoPlayCallback.this.callback.sendError((Object)mediaChannelResult.getStatus().toString());
                    }
                });
                return;
            }
            catch (IllegalStateException illegalStateException) {
                ChromeCast.this.debug("Problem occurred with media during loading", illegalStateException);
            }
            catch (Exception exception) {
                ChromeCast.this.debug("Problem opening media during loading", exception);
            }
            this.callback.sendError((Object)"");
        }
    }
}

