/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;

public final class TabsAccessor {
    private static final String LOGTAG = "GeckoTabsAccessor";
    public static final String[] TABS_PROJECTION_COLUMNS = new String[]{"title", "url", "guid", "name", "last_modified", "device_type"};
    private static final String LOCAL_TABS_SELECTION = "client_guid IS NULL";
    private static final String REMOTE_TABS_SELECTION = "client_guid IS NOT NULL";
    private static final String REMOTE_TABS_SORT_ORDER = "last_modified DESC, guid DESC, last_used DESC";
    private static final String LOCAL_CLIENT_SELECTION = "guid IS NULL";
    private static final Pattern FILTERED_URL_PATTERN = Pattern.compile("^(about|chrome|wyciwyg|file):");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RemoteClient> getClientsFromCursor(Cursor cursor) {
        ArrayList<RemoteClient> arrayList = new ArrayList<RemoteClient>();
        int n = cursor.getPosition();
        try {
            if (!cursor.moveToFirst()) {
                ArrayList<RemoteClient> arrayList2 = arrayList;
                return arrayList2;
            }
            int n2 = cursor.getColumnIndex("title");
            int n3 = cursor.getColumnIndex("url");
            int n4 = cursor.getColumnIndex("guid");
            int n5 = cursor.getColumnIndex("name");
            int n6 = cursor.getColumnIndex("last_modified");
            int n7 = cursor.getColumnIndex("device_type");
            RemoteClient remoteClient = null;
            while (!cursor.isAfterLast()) {
                String string2;
                String string3 = cursor.getString(n4);
                if (remoteClient == null || !TextUtils.equals((CharSequence)remoteClient.guid, (CharSequence)string3)) {
                    string2 = cursor.getString(n5);
                    long l = cursor.getLong(n6);
                    String string4 = cursor.getString(n7);
                    remoteClient = new RemoteClient(string3, string2, l, string4);
                    arrayList.add(remoteClient);
                }
                string2 = cursor.getString(n2);
                String string5 = cursor.getString(n3);
                remoteClient.tabs.add(new RemoteTab(string2, string5));
                cursor.moveToNext();
            }
        }
        finally {
            cursor.moveToPosition(n);
        }
        return arrayList;
    }

    public static Cursor getRemoteTabsCursor(Context context) {
        return TabsAccessor.getRemoteTabsCursor(context, -1);
    }

    public static Cursor getRemoteTabsCursor(Context context, int n) {
        Uri uri = BrowserContract.Tabs.CONTENT_URI;
        if (n > 0) {
            uri = uri.buildUpon().appendQueryParameter("limit", String.valueOf(n)).build();
        }
        Cursor cursor = context.getContentResolver().query(uri, TABS_PROJECTION_COLUMNS, REMOTE_TABS_SELECTION, null, REMOTE_TABS_SORT_ORDER);
        return cursor;
    }

    public static void getTabs(Context context, OnQueryTabsCompleteListener onQueryTabsCompleteListener) {
        TabsAccessor.getTabs(context, 0, onQueryTabsCompleteListener);
    }

    public static void getTabs(final Context context, final int n, final OnQueryTabsCompleteListener onQueryTabsCompleteListener) {
        if (onQueryTabsCompleteListener == null) {
            return;
        }
        new UIAsyncTask.WithoutParams<List<RemoteClient>>(ThreadUtils.getBackgroundHandler()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<RemoteClient> doInBackground() {
                Cursor cursor = TabsAccessor.getRemoteTabsCursor(context, n);
                if (cursor == null) {
                    return null;
                }
                try {
                    List<RemoteClient> list = Collections.unmodifiableList(TabsAccessor.getClientsFromCursor(cursor));
                    return list;
                }
                finally {
                    cursor.close();
                }
            }

            protected void onPostExecute(List<RemoteClient> list) {
                onQueryTabsCompleteListener.onQueryTabsComplete(list);
            }
        }.execute();
    }

    private static void updateLocalClient(ContentResolver contentResolver) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("last_modified", Long.valueOf(System.currentTimeMillis()));
        contentResolver.update(BrowserContract.Clients.CONTENT_URI, contentValues, LOCAL_CLIENT_SELECTION, null);
    }

    private static void deleteLocalTabs(ContentResolver contentResolver) {
        contentResolver.delete(BrowserContract.Tabs.CONTENT_URI, LOCAL_TABS_SELECTION, null);
    }

    private static void insertLocalTabs(ContentResolver contentResolver, Iterable<Tab> iterable) {
        JSONArray jSONArray = new JSONArray();
        ArrayList<ContentValues> arrayList = new ArrayList<ContentValues>();
        int n = 0;
        for (Tab tab : iterable) {
            String string2 = tab.getURL();
            if (string2 == null || tab.isPrivate() || TabsAccessor.isFilteredURL(string2)) continue;
            ContentValues contentValues = new ContentValues();
            contentValues.put("url", string2);
            contentValues.put("title", tab.getTitle());
            contentValues.put("last_used", Long.valueOf(tab.getLastUsed()));
            String string3 = tab.getFaviconURL();
            if (string3 != null) {
                contentValues.put("favicon", string3);
            } else {
                contentValues.putNull("favicon");
            }
            try {
                jSONArray.put(0, (Object)tab.getURL());
                contentValues.put("history", jSONArray.toString());
            }
            catch (JSONException jSONException) {
                Log.w((String)LOGTAG, (String)"JSONException adding URL to tab history array.", (Throwable)jSONException);
            }
            contentValues.put("position", Integer.valueOf(n++));
            contentValues.putNull("client_guid");
            arrayList.add(contentValues);
        }
        ContentValues[] contentValuesArray = arrayList.toArray(new ContentValues[arrayList.size()]);
        contentResolver.bulkInsert(BrowserContract.Tabs.CONTENT_URI, contentValuesArray);
    }

    public static synchronized void persistLocalTabs(ContentResolver contentResolver, Iterable<Tab> iterable) {
        TabsAccessor.deleteLocalTabs(contentResolver);
        TabsAccessor.insertLocalTabs(contentResolver, iterable);
        TabsAccessor.updateLocalClient(contentResolver);
    }

    private static boolean isFilteredURL(String string2) {
        return FILTERED_URL_PATTERN.matcher(string2).lookingAt();
    }

    public static String getLastSyncedString(Context context, long l, long l2) {
        CharSequence charSequence = DateUtils.getRelativeTimeSpanString((long)l2, (long)l, (long)60000L);
        return context.getResources().getString(R.string.remote_tabs_last_synced, new Object[]{charSequence});
    }

    public static interface OnQueryTabsCompleteListener {
        public void onQueryTabsComplete(List<RemoteClient> var1);
    }

    public static class RemoteTab
    implements Parcelable {
        public final String title;
        public final String url;
        public static final Parcelable.Creator<RemoteTab> CREATOR = new Parcelable.Creator<RemoteTab>(){

            public RemoteTab createFromParcel(Parcel parcel) {
                String string2 = parcel.readString();
                String string3 = parcel.readString();
                return new RemoteTab(string2, string3);
            }

            public RemoteTab[] newArray(int n) {
                return new RemoteTab[n];
            }
        };

        public RemoteTab(String string2, String string3) {
            this.title = string2;
            this.url = string3;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.title);
            parcel.writeString(this.url);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.title == null ? 0 : this.title.hashCode());
            n = 31 * n + (this.url == null ? 0 : this.url.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            RemoteTab remoteTab = (RemoteTab)object;
            if (this.title == null ? remoteTab.title != null : !this.title.equals(remoteTab.title)) {
                return false;
            }
            return !(this.url == null ? remoteTab.url != null : !this.url.equals(remoteTab.url));
        }
    }

    public static class RemoteClient
    implements Parcelable {
        public final String guid;
        public final String name;
        public final long lastModified;
        public final String deviceType;
        public final ArrayList<RemoteTab> tabs;
        public static final Parcelable.Creator<RemoteClient> CREATOR = new Parcelable.Creator<RemoteClient>(){

            public RemoteClient createFromParcel(Parcel parcel) {
                String string2 = parcel.readString();
                String string3 = parcel.readString();
                long l = parcel.readLong();
                String string4 = parcel.readString();
                RemoteClient remoteClient = new RemoteClient(string2, string3, l, string4);
                parcel.readTypedList(remoteClient.tabs, RemoteTab.CREATOR);
                return remoteClient;
            }

            public RemoteClient[] newArray(int n) {
                return new RemoteClient[n];
            }
        };

        public RemoteClient(String string2, String string3, long l, String string4) {
            this.guid = string2;
            this.name = string3;
            this.lastModified = l;
            this.deviceType = string4;
            this.tabs = new ArrayList();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.guid);
            parcel.writeString(this.name);
            parcel.writeLong(this.lastModified);
            parcel.writeString(this.deviceType);
            parcel.writeTypedList(this.tabs);
        }
    }
}

