/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa;

import ch.boye.httpclientandroidlib.HttpResponse;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.concurrent.Executor;
import org.json.simple.JSONObject;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccount20CreateDelegate;
import org.mozilla.gecko.background.fxa.FxAccount20LoginDelegate;
import org.mozilla.gecko.background.fxa.FxAccountClient;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.PasswordStretcher;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.Resource;

public class FxAccountClient20
extends FxAccountClient10
implements FxAccountClient {
    protected static final String[] LOGIN_RESPONSE_REQUIRED_STRING_FIELDS = new String[]{"uid", "sessionToken"};
    protected static final String[] LOGIN_RESPONSE_REQUIRED_STRING_FIELDS_KEYS = new String[]{"uid", "sessionToken", "keyFetchToken"};
    protected static final String[] LOGIN_RESPONSE_REQUIRED_BOOLEAN_FIELDS = new String[]{"verified"};

    public FxAccountClient20(String string2, Executor executor) {
        super(string2, executor);
    }

    public void login(final byte[] byArray, byte[] byArray2, final boolean bl, FxAccountClient10.RequestDelegate<LoginResponse> requestDelegate) {
        JSONObject jSONObject;
        BaseResource baseResource;
        String string2 = bl ? "account/login?keys=true" : "account/login";
        try {
            baseResource = new BaseResource(new URI(this.serverURI + string2));
            jSONObject = new FxAccount20LoginDelegate(byArray, byArray2).getCreateBody();
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        baseResource.delegate = new FxAccountClient10.ResourceDelegate<LoginResponse>((Resource)baseResource, requestDelegate){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    String[] stringArray = bl ? LOGIN_RESPONSE_REQUIRED_STRING_FIELDS_KEYS : LOGIN_RESPONSE_REQUIRED_STRING_FIELDS;
                    extendedJSONObject.throwIfFieldsMissingOrMisTyped(stringArray, String.class);
                    String[] stringArray2 = LOGIN_RESPONSE_REQUIRED_BOOLEAN_FIELDS;
                    extendedJSONObject.throwIfFieldsMissingOrMisTyped(stringArray2, Boolean.class);
                    String string2 = extendedJSONObject.getString("uid");
                    boolean bl2 = extendedJSONObject.getBoolean("verified");
                    byte[] byArray3 = Utils.hex2Byte(extendedJSONObject.getString("sessionToken"));
                    byte[] byArray2 = null;
                    if (bl) {
                        byArray2 = Utils.hex2Byte(extendedJSONObject.getString("keyFetchToken"));
                    }
                    LoginResponse loginResponse = new LoginResponse(new String(byArray, "UTF-8"), string2, bl2, byArray3, byArray2);
                    this.delegate.handleSuccess(loginResponse);
                    return;
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        this.post(baseResource, jSONObject, requestDelegate);
    }

    protected URI getCreateAccountURI(boolean bl, String string2) throws UnsupportedEncodingException, URISyntaxException {
        if (string2 == null) {
            throw new IllegalArgumentException("service must not be null");
        }
        StringBuilder stringBuilder = new StringBuilder(this.serverURI);
        stringBuilder.append("account/create?service=");
        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
        if (bl) {
            stringBuilder.append("&keys=true");
        }
        return new URI(stringBuilder.toString());
    }

    public void createAccount(final byte[] byArray, byte[] byArray2, final boolean bl, boolean bl2, String string2, FxAccountClient10.RequestDelegate<LoginResponse> requestDelegate) {
        JSONObject jSONObject;
        BaseResource baseResource;
        try {
            baseResource = new BaseResource(this.getCreateAccountURI(bl, string2));
            jSONObject = new FxAccount20CreateDelegate(byArray, byArray2, bl2).getCreateBody();
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        baseResource.delegate = new FxAccountClient10.ResourceDelegate<LoginResponse>((Resource)baseResource, requestDelegate){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    String[] stringArray = bl ? LOGIN_RESPONSE_REQUIRED_STRING_FIELDS_KEYS : LOGIN_RESPONSE_REQUIRED_STRING_FIELDS;
                    extendedJSONObject.throwIfFieldsMissingOrMisTyped(stringArray, String.class);
                    String string2 = extendedJSONObject.getString("uid");
                    boolean bl3 = false;
                    Boolean bl2 = extendedJSONObject.getBoolean("verified");
                    if (bl2 != null) {
                        bl3 = bl2;
                    }
                    byte[] byArray3 = Utils.hex2Byte(extendedJSONObject.getString("sessionToken"));
                    byte[] byArray2 = null;
                    if (bl) {
                        byArray2 = Utils.hex2Byte(extendedJSONObject.getString("keyFetchToken"));
                    }
                    LoginResponse loginResponse = new LoginResponse(new String(byArray, "UTF-8"), string2, bl3, byArray3, byArray2);
                    this.delegate.handleSuccess(loginResponse);
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                }
            }
        };
        this.post(baseResource, jSONObject, requestDelegate);
    }

    @Override
    public void createAccountAndGetKeys(byte[] byArray, PasswordStretcher passwordStretcher, FxAccountClient10.RequestDelegate<LoginResponse> requestDelegate) {
        try {
            byte[] byArray2 = passwordStretcher.getQuickStretchedPW(byArray);
            this.createAccount(byArray, byArray2, true, false, "sync", requestDelegate);
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
        }
    }

    @Override
    public void loginAndGetKeys(byte[] byArray, PasswordStretcher passwordStretcher, FxAccountClient10.RequestDelegate<LoginResponse> requestDelegate) {
        this.login(byArray, passwordStretcher, true, requestDelegate);
    }

    public void login(byte[] byArray, final PasswordStretcher passwordStretcher, final boolean bl, final FxAccountClient10.RequestDelegate<LoginResponse> requestDelegate) {
        byte[] byArray2;
        try {
            FxAccountConstants.pii(LOG_TAG, "Trying user provided email: '" + new String(byArray, "UTF-8") + "'");
            byArray2 = passwordStretcher.getQuickStretchedPW(byArray);
        }
        catch (Exception exception) {
            requestDelegate.handleError(exception);
            return;
        }
        this.login(byArray, byArray2, bl, new FxAccountClient10.RequestDelegate<LoginResponse>(){

            @Override
            public void handleSuccess(LoginResponse loginResponse) {
                requestDelegate.handleSuccess(loginResponse);
            }

            @Override
            public void handleError(Exception exception) {
                requestDelegate.handleError(exception);
            }

            @Override
            public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
                String string2 = fxAccountClientRemoteException.body.getString("email");
                if (!fxAccountClientRemoteException.isBadEmailCase() || string2 == null) {
                    requestDelegate.handleFailure(fxAccountClientRemoteException);
                    return;
                }
                Logger.info(FxAccountClient10.LOG_TAG, "Server returned alternate email; retrying login with provided email.");
                FxAccountConstants.pii(FxAccountClient10.LOG_TAG, "Trying server provided email: '" + string2 + "'");
                try {
                    byte[] byArray = string2.getBytes("UTF-8");
                    byte[] byArray2 = passwordStretcher.getQuickStretchedPW(byArray);
                    FxAccountClient20.this.login(byArray, byArray2, bl, (FxAccountClient10.RequestDelegate<LoginResponse>)requestDelegate);
                }
                catch (Exception exception) {
                    requestDelegate.handleError(exception);
                    return;
                }
            }
        });
    }

    public static class LoginResponse {
        public final String remoteEmail;
        public final String uid;
        public final byte[] sessionToken;
        public final boolean verified;
        public final byte[] keyFetchToken;

        public LoginResponse(String string2, String string3, boolean bl, byte[] byArray, byte[] byArray2) {
            this.remoteEmail = string2;
            this.uid = string3;
            this.verified = bl;
            this.sessionToken = byArray;
            this.keyFetchToken = byArray2;
        }
    }
}

