/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.distribution;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.distribution.Distribution;
import org.mozilla.gecko.distribution.ReferrerDescriptor;
import org.mozilla.gecko.mozglue.RobocopTarget;

public class ReferrerReceiver
extends BroadcastReceiver {
    private static final String LOGTAG = "GeckoReferrerReceiver";
    private static final String ACTION_INSTALL_REFERRER = "com.android.vending.INSTALL_REFERRER";
    @RobocopTarget
    public static final String ACTION_REFERRER_RECEIVED = "org.mozilla.fennec.REFERRER_RECEIVED";
    private static final String MOZILLA_UTM_SOURCE = "mozilla";
    private static final String DISTRIBUTION_UTM_CAMPAIGN = "distribution";

    public void onReceive(Context context, Intent intent) {
        Log.v((String)LOGTAG, (String)("Received intent " + intent));
        if (!ACTION_INSTALL_REFERRER.equals(intent.getAction())) {
            return;
        }
        ReferrerDescriptor referrerDescriptor = new ReferrerDescriptor(intent.getStringExtra("referrer"));
        if (TextUtils.equals((CharSequence)referrerDescriptor.campaign, (CharSequence)DISTRIBUTION_UTM_CAMPAIGN)) {
            Distribution.onReceivedReferrer(referrerDescriptor);
        } else {
            Log.d((String)LOGTAG, (String)"Not downloading distribution: non-matching campaign.");
        }
        if (TextUtils.equals((CharSequence)referrerDescriptor.source, (CharSequence)MOZILLA_UTM_SOURCE)) {
            this.propagateMozillaCampaign(referrerDescriptor);
        }
        Intent intent2 = new Intent(ACTION_REFERRER_RECEIVED);
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent2);
    }

    private void propagateMozillaCampaign(ReferrerDescriptor referrerDescriptor) {
        if (referrerDescriptor.campaign == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("id", (Object)"playstore");
            jSONObject.put("version", (Object)referrerDescriptor.campaign);
            String string2 = jSONObject.toString();
            GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Campaign:Set", string2);
            GeckoAppShell.sendEventToGecko(geckoEvent);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error propagating campaign identifier.", (Throwable)jSONException);
        }
    }
}

