/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.ImageView;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.tabs.TabCurve;
import org.mozilla.gecko.widget.ThemedImageButton;
import org.mozilla.gecko.widget.ThemedLinearLayout;
import org.mozilla.gecko.widget.ThemedTextView;

public class TabStripItemView
extends ThemedLinearLayout
implements Checkable {
    private static final String LOGTAG = "GeckoTabStripItem";
    private static final int[] STATE_CHECKED = new int[]{0x10100A0};
    private int id = -1;
    private boolean checked;
    private final ImageView faviconView;
    private final ThemedTextView titleView;
    private final ThemedImageButton closeView;
    private final Paint tabPaint;
    private final Path tabShape;
    private final Region tabRegion;
    private final Region tabClipRegion;
    private final int faviconSize;
    private Bitmap lastFavicon;

    public TabStripItemView(Context context) {
        this(context, null);
    }

    public TabStripItemView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setOrientation(0);
        this.tabShape = new Path();
        this.tabRegion = new Region();
        this.tabClipRegion = new Region();
        this.tabPaint = new Paint();
        this.tabPaint.setAntiAlias(true);
        this.tabPaint.setColor(-65536);
        this.tabPaint.setStrokeWidth(0.0f);
        this.tabPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        this.faviconSize = this.getResources().getDimensionPixelSize(R.dimen.new_tablet_tab_strip_favicon_size);
        LayoutInflater.from((Context)context).inflate(R.layout.tab_strip_item_view, (ViewGroup)this);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TabStripItemView.this.id < 0) {
                    throw new IllegalStateException("Invalid tab id:" + TabStripItemView.this.id);
                }
                Tabs.getInstance().selectTab(TabStripItemView.this.id);
            }
        });
        this.faviconView = (ImageView)this.findViewById(R.id.favicon);
        this.titleView = (ThemedTextView)this.findViewById(R.id.title);
        this.closeView = (ThemedImageButton)this.findViewById(R.id.close);
        this.closeView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TabStripItemView.this.id < 0) {
                    throw new IllegalStateException("Invalid tab id:" + TabStripItemView.this.id);
                }
                Tabs tabs = Tabs.getInstance();
                tabs.closeTab(tabs.getTab(TabStripItemView.this.id), true);
            }
        });
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.tabShape.reset();
        int n5 = TabCurve.getWidthForHeight(n2);
        this.tabShape.moveTo(0.0f, (float)n2);
        TabCurve.drawFromBottom(this.tabShape, 0, n2, TabCurve.Direction.RIGHT);
        this.tabShape.lineTo((float)(n - n5), 0.0f);
        TabCurve.drawFromTop(this.tabShape, n - n5, n2, TabCurve.Direction.RIGHT);
        this.tabShape.lineTo(0.0f, (float)n2);
        this.tabClipRegion.set(0, 0, n, n2);
        this.tabRegion.setPath(this.tabShape, this.tabClipRegion);
    }

    public void draw(Canvas canvas) {
        int n = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
        super.draw(canvas);
        canvas.drawPath(this.tabShape, this.tabPaint);
        canvas.restoreToCount(n);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        int n2 = (int)motionEvent.getX();
        int n3 = (int)motionEvent.getY();
        if (n == 0 && !this.tabRegion.contains(n2, n3)) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    @Override
    public int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        if (this.checked) {
            TabStripItemView.mergeDrawableStates((int[])nArray, (int[])STATE_CHECKED);
        }
        return nArray;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean bl) {
        if (this.checked == bl) {
            return;
        }
        this.checked = bl;
        this.refreshDrawableState();
    }

    public void toggle() {
        this.setChecked(!this.checked);
    }

    public void setPressed(boolean bl) {
        super.setPressed(bl);
        View view = (View)this.getParent();
        if (view != null) {
            view.invalidate();
        }
    }

    void updateFromTab(Tab tab) {
        if (tab == null) {
            return;
        }
        this.id = tab.getId();
        this.updateTitle(tab);
        this.updateFavicon(tab.getFavicon());
        this.setPrivateMode(tab.isPrivate());
    }

    private void updateTitle(Tab tab) {
        if (AboutPages.isAboutHome(tab.getURL())) {
            this.titleView.setText(R.string.home_title);
        } else {
            this.titleView.setText(tab.getDisplayTitle());
        }
    }

    private void updateFavicon(Bitmap bitmap) {
        if (bitmap == null) {
            this.lastFavicon = null;
            this.faviconView.setImageResource(R.drawable.new_tablet_default_favicon);
            return;
        }
        if (bitmap == this.lastFavicon) {
            return;
        }
        this.lastFavicon = bitmap;
        Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.faviconSize, (int)this.faviconSize, (boolean)false);
        this.faviconView.setImageBitmap(bitmap2);
    }
}

