/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputConnection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mozilla.gecko.GeckoEditable;
import org.mozilla.gecko.GeckoEditableClient;
import org.mozilla.gecko.GeckoEditableListener;
import org.mozilla.gecko.GeckoInputConnection;
import org.mozilla.gecko.gfx.InputConnectionHandler;

final class DebugGeckoInputConnection
extends GeckoInputConnection
implements InvocationHandler {
    private InputConnection mProxy;
    private final StringBuilder mCallLevel = new StringBuilder();

    private DebugGeckoInputConnection(View view, GeckoEditableClient geckoEditableClient) {
        super(view, geckoEditableClient);
    }

    public static GeckoEditableListener create(View view, GeckoEditableClient geckoEditableClient) {
        Class[] classArray = new Class[]{InputConnection.class, InputConnectionHandler.class, GeckoEditableListener.class};
        DebugGeckoInputConnection debugGeckoInputConnection = new DebugGeckoInputConnection(view, geckoEditableClient);
        debugGeckoInputConnection.mProxy = (InputConnection)Proxy.newProxyInstance(GeckoInputConnection.class.getClassLoader(), classArray, (InvocationHandler)debugGeckoInputConnection);
        return (GeckoEditableListener)debugGeckoInputConnection.mProxy;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        StringBuilder stringBuilder = new StringBuilder(this.mCallLevel);
        stringBuilder.append("> ").append(method.getName()).append("(");
        if (objectArray != null) {
            for (Object object2 : objectArray) {
                if ("notifyIME".equals(method.getName()) && object2 == objectArray[0]) {
                    stringBuilder.append(GeckoEditable.getConstantName(GeckoEditableListener.class, "NOTIFY_IME_", object2));
                } else if ("notifyIMEContext".equals(method.getName()) && object2 == objectArray[0]) {
                    stringBuilder.append(GeckoEditable.getConstantName(GeckoEditableListener.class, "IME_STATE_", object2));
                } else {
                    GeckoEditable.debugAppend(stringBuilder, object2);
                }
                stringBuilder.append(", ");
            }
            if (objectArray.length > 0) {
                stringBuilder.setLength(stringBuilder.length() - 2);
            }
        }
        stringBuilder.append(")");
        Log.d((String)"GeckoInputConnection", (String)stringBuilder.toString());
        this.mCallLevel.append(' ');
        InputConnection inputConnection = method.invoke((Object)this, objectArray);
        if (inputConnection == this) {
            inputConnection = this.mProxy;
        }
        this.mCallLevel.setLength(Math.max(0, this.mCallLevel.length() - 1));
        stringBuilder.setLength(this.mCallLevel.length());
        stringBuilder.append("< ").append(method.getName());
        if (!method.getReturnType().equals(Void.TYPE)) {
            GeckoEditable.debugAppend(stringBuilder.append(": "), inputConnection);
        }
        Log.d((String)"GeckoInputConnection", (String)stringBuilder.toString());
        return inputConnection;
    }
}

