/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import java.io.File;
import java.util.EnumSet;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.authenticator.AccountPickler;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.sync.FxAccountSyncStatusHelper;
import org.mozilla.gecko.fxa.tasks.FxAccountCodeResender;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.Utils;

public class FirefoxAccounts {
    private static final String LOG_TAG = FirefoxAccounts.class.getSimpleName();
    public static final EnumSet<SyncHint> SOON = EnumSet.noneOf(SyncHint.class);
    public static final EnumSet<SyncHint> NOW = EnumSet.of(SyncHint.SCHEDULE_NOW);
    public static final EnumSet<SyncHint> FORCE = EnumSet.of(SyncHint.SCHEDULE_NOW, SyncHint.IGNORE_LOCAL_RATE_LIMIT, SyncHint.IGNORE_REMOTE_SERVER_BACKOFF);

    public static boolean firefoxAccountsExist(Context context) {
        return FirefoxAccounts.getFirefoxAccounts(context).length > 0;
    }

    public static Account[] getFirefoxAccounts(Context context) {
        Account[] accountArray;
        Account[] accountArray2 = AccountManager.get((Context)context).getAccountsByType("org.mozilla.fennec_fxaccount");
        if (accountArray2.length > 0) {
            return accountArray2;
        }
        Account account = FirefoxAccounts.getPickledAccount(context);
        if (account != null) {
            Account[] accountArray3 = new Account[1];
            accountArray = accountArray3;
            accountArray3[0] = account;
        } else {
            accountArray = new Account[]{};
        }
        return accountArray;
    }

    private static Account getPickledAccount(final Context context) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Account[] accountArray = new Account[1];
        ThreadPool.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    File file = context.getFileStreamPath("fxa.account.json");
                    if (!file.exists()) {
                        accountArray[0] = null;
                        return;
                    }
                    AndroidFxAccount androidFxAccount = AccountPickler.unpickle(context, "fxa.account.json");
                    accountArray[0] = androidFxAccount.getAndroidAccount();
                }
                finally {
                    countDownLatch.countDown();
                }
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Logger.warn(LOG_TAG, "Foreground thread unexpectedly interrupted while getting pickled account", interruptedException);
            return null;
        }
        return accountArray[0];
    }

    public static Account getFirefoxAccount(Context context) {
        Account[] accountArray = FirefoxAccounts.getFirefoxAccounts(context);
        if (accountArray.length > 0) {
            return accountArray[0];
        }
        return null;
    }

    public static State getFirefoxAccountState(Context context) {
        Account account = FirefoxAccounts.getFirefoxAccount(context);
        if (account == null) {
            return null;
        }
        AndroidFxAccount androidFxAccount = new AndroidFxAccount(context, account);
        try {
            return androidFxAccount.getState();
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Could not get FX account state.", exception);
            return null;
        }
    }

    public static String getFirefoxAccountEmail(Context context) {
        Account account = FirefoxAccounts.getFirefoxAccount(context);
        if (account == null) {
            return null;
        }
        return account.name;
    }

    protected static void putHintsToSync(Bundle bundle, EnumSet<SyncHint> enumSet) {
        if (enumSet == null) {
            throw new IllegalArgumentException("syncHints must not be null");
        }
        boolean bl = enumSet.contains((Object)SyncHint.SCHEDULE_NOW);
        boolean bl2 = enumSet.contains((Object)SyncHint.IGNORE_LOCAL_RATE_LIMIT);
        boolean bl3 = enumSet.contains((Object)SyncHint.IGNORE_REMOTE_SERVER_BACKOFF);
        bundle.putBoolean("force", bl);
        bundle.putBoolean("respect_local_rate_limit", !bl2);
        bundle.putBoolean("respect_remote_server_backoff", !bl3);
    }

    public static EnumSet<SyncHint> getHintsToSyncFromBundle(Bundle bundle) {
        boolean bl;
        EnumSet<SyncHint> enumSet = EnumSet.noneOf(SyncHint.class);
        boolean bl2 = bundle.getBoolean("force", false);
        boolean bl3 = !bundle.getBoolean("respect_local_rate_limit", false);
        boolean bl4 = bl = !bundle.getBoolean("respect_remote_server_backoff", false);
        if (bl2) {
            enumSet.add(SyncHint.SCHEDULE_NOW);
        }
        if (bl3) {
            enumSet.add(SyncHint.IGNORE_LOCAL_RATE_LIMIT);
        }
        if (bl) {
            enumSet.add(SyncHint.IGNORE_REMOTE_SERVER_BACKOFF);
        }
        return enumSet;
    }

    public static void logSyncHints(EnumSet<SyncHint> enumSet) {
        boolean bl = enumSet.contains((Object)SyncHint.SCHEDULE_NOW);
        boolean bl2 = enumSet.contains((Object)SyncHint.IGNORE_LOCAL_RATE_LIMIT);
        boolean bl3 = enumSet.contains((Object)SyncHint.IGNORE_REMOTE_SERVER_BACKOFF);
        Logger.info(LOG_TAG, "Sync hints; scheduling now: " + bl + "; ignoring local rate limit: " + bl2 + "; ignoring remote server backoff: " + bl3 + ".");
    }

    public static void requestSync(final Account account, EnumSet<SyncHint> enumSet, String[] stringArray, String[] stringArray2) {
        if (account == null) {
            throw new IllegalArgumentException("account must not be null");
        }
        if (enumSet == null) {
            throw new IllegalArgumentException("syncHints must not be null");
        }
        final Bundle bundle = new Bundle();
        FirefoxAccounts.putHintsToSync(bundle, enumSet);
        Utils.putStageNamesToSync(bundle, stringArray, stringArray2);
        Logger.info(LOG_TAG, "Requesting sync.");
        FirefoxAccounts.logSyncHints(enumSet);
        ThreadPool.run(new Runnable(){

            @Override
            public void run() {
                for (String string2 : AndroidFxAccount.getAndroidAuthorities()) {
                    ContentResolver.requestSync((Account)account, (String)string2, (Bundle)bundle);
                }
            }
        });
    }

    public static void addSyncStatusListener(SyncStatusListener syncStatusListener) {
        FxAccountSyncStatusHelper.getInstance().startObserving(syncStatusListener);
    }

    public static void removeSyncStatusListener(SyncStatusListener syncStatusListener) {
        FxAccountSyncStatusHelper.getInstance().stopObserving(syncStatusListener);
    }

    public static String getOldSyncUpgradeURL(Resources resources, Locale locale) {
        String string2 = Utils.getLanguageTag(locale);
        return resources.getString(R.string.fxaccount_link_old_firefox, new Object[]{"36.0a1", "Android", string2});
    }

    public static boolean resendVerificationEmail(Context context) {
        Account account = FirefoxAccounts.getFirefoxAccount(context);
        if (account == null) {
            return false;
        }
        AndroidFxAccount androidFxAccount = new AndroidFxAccount(context, account);
        FxAccountCodeResender.resendCode(context, androidFxAccount);
        return true;
    }

    public static interface SyncStatusListener {
        public Context getContext();

        public Account getAccount();

        public void onSyncStarted();

        public void onSyncFinished();
    }

    public static enum SyncHint {
        SCHEDULE_NOW,
        IGNORE_LOCAL_RATE_LIMIT,
        IGNORE_REMOTE_SERVER_BACKOFF;

    }
}

