/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.overlays.ui;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.Arrays;
import org.mozilla.gecko.Assert;
import org.mozilla.gecko.R;
import org.mozilla.gecko.overlays.service.sharemethods.ParcelableClientRecord;
import org.mozilla.gecko.overlays.ui.SendTabDeviceListArrayAdapter;
import org.mozilla.gecko.overlays.ui.SendTabTargetSelectedListener;

public class SendTabList
extends ListView {
    private static final String LOGTAG = "GeckoSendTabList";
    public static final int MAXIMUM_INLINE_ELEMENTS = 2;
    private SendTabDeviceListArrayAdapter clientListAdapter;
    private SendTabTargetSelectedListener listener;
    private final State currentState = State.LOADING;

    public SendTabList(Context context) {
        super(context);
    }

    public SendTabList(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public void setAdapter(ListAdapter listAdapter) {
        Assert.isTrue(listAdapter instanceof SendTabDeviceListArrayAdapter);
        this.clientListAdapter = (SendTabDeviceListArrayAdapter)listAdapter;
        super.setAdapter(listAdapter);
    }

    public void setSendTabTargetSelectedListener(SendTabTargetSelectedListener sendTabTargetSelectedListener) {
        this.listener = sendTabTargetSelectedListener;
    }

    public void switchState(State state) {
        if (state == this.currentState) {
            return;
        }
        this.clientListAdapter.switchState(state);
        if (state == State.SHOW_DEVICES) {
            this.clientListAdapter.setDialog(this.getDialog());
        }
    }

    public void setSyncClients(ParcelableClientRecord[] parcelableClientRecordArray) {
        ParcelableClientRecord[] parcelableClientRecordArray2 = parcelableClientRecordArray == null ? new ParcelableClientRecord[]{} : parcelableClientRecordArray;
        this.clientListAdapter.setClientRecordList(Arrays.asList(parcelableClientRecordArray2));
        if (parcelableClientRecordArray2.length <= 2) {
            this.switchState(State.LIST);
            return;
        }
        this.switchState(State.SHOW_DEVICES);
    }

    public AlertDialog getDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        final ParcelableClientRecord[] parcelableClientRecordArray = this.clientListAdapter.toArray();
        CharSequence[] charSequenceArray = new String[parcelableClientRecordArray.length];
        for (int i = 0; i < parcelableClientRecordArray.length; ++i) {
            charSequenceArray[i] = parcelableClientRecordArray[i].name;
        }
        builder.setTitle(R.string.overlay_share_select_device).setItems(charSequenceArray, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                SendTabList.this.listener.onSendTabTargetSelected(parcelableClientRecordArray[n].guid);
            }
        });
        return builder.create();
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 2) {
            return true;
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    public static enum State {
        NONE,
        LOADING,
        LIST,
        SHOW_DEVICES;

    }
}

