/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories;

import java.io.IOException;
import org.json.simple.parser.ParseException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;

public class RepositorySessionBundle {
    public static final String LOG_TAG = RepositorySessionBundle.class.getSimpleName();
    protected static final String JSON_KEY_TIMESTAMP = "timestamp";
    protected final ExtendedJSONObject object;

    public RepositorySessionBundle(String string2) throws IOException, ParseException, NonObjectJSONException {
        this.object = ExtendedJSONObject.parseJSONObject(string2);
    }

    public RepositorySessionBundle(long l) {
        this.object = new ExtendedJSONObject();
        this.setTimestamp(l);
    }

    public long getTimestamp() {
        if (this.object.containsKey(JSON_KEY_TIMESTAMP)) {
            return this.object.getLong(JSON_KEY_TIMESTAMP);
        }
        return -1L;
    }

    public void setTimestamp(long l) {
        Logger.debug(LOG_TAG, "Setting timestamp to " + l + ".");
        this.object.put(JSON_KEY_TIMESTAMP, l);
    }

    public void bumpTimestamp(long l) {
        long l2 = this.getTimestamp();
        if (l > l2) {
            this.setTimestamp(l);
        } else {
            Logger.debug(LOG_TAG, "Timestamp " + l + " not greater than " + l2 + "; not bumping.");
        }
    }

    public String toJSONString() {
        return this.object.toJSONString();
    }
}

