/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserHistoryDataExtender;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserRepositoryDataAccessor;
import org.mozilla.gecko.sync.repositories.android.BrowserContractHelpers;
import org.mozilla.gecko.sync.repositories.domain.HistoryRecord;
import org.mozilla.gecko.sync.repositories.domain.Record;

public class AndroidBrowserHistoryDataAccessor
extends AndroidBrowserRepositoryDataAccessor {
    private final AndroidBrowserHistoryDataExtender dataExtender;
    public static String[] GUID_AND_ID = new String[]{"guid", "_id"};

    public AndroidBrowserHistoryDataAccessor(Context context) {
        super(context);
        this.dataExtender = new AndroidBrowserHistoryDataExtender(context);
    }

    public AndroidBrowserHistoryDataExtender getHistoryDataExtender() {
        return this.dataExtender;
    }

    @Override
    protected Uri getUri() {
        return BrowserContractHelpers.HISTORY_CONTENT_URI;
    }

    @Override
    protected ContentValues getContentValues(Record record) {
        ContentValues contentValues = new ContentValues();
        HistoryRecord historyRecord = (HistoryRecord)record;
        contentValues.put("guid", historyRecord.guid);
        contentValues.put("title", historyRecord.title);
        contentValues.put("url", historyRecord.histURI);
        if (historyRecord.visits != null) {
            JSONArray jSONArray = historyRecord.visits;
            long l = 0L;
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONObject jSONObject = (JSONObject)jSONArray.get(i);
                long l2 = (Long)jSONObject.get((Object)"date");
                if (l2 <= l) continue;
                l = l2;
            }
            contentValues.put("date", Long.valueOf(l / 1000L));
            contentValues.put("visits", Long.toString(jSONArray.size()));
        }
        return contentValues;
    }

    @Override
    protected String[] getAllColumns() {
        return BrowserContractHelpers.HistoryColumns;
    }

    @Override
    public Uri insert(Record record) {
        HistoryRecord historyRecord = (HistoryRecord)record;
        Logger.debug(LOG_TAG, "Storing visits for " + record.guid);
        this.dataExtender.store(record.guid, historyRecord.visits);
        Logger.debug(LOG_TAG, "Storing record " + record.guid);
        return super.insert(record);
    }

    @Override
    public void update(String string2, Record record) {
        HistoryRecord historyRecord = (HistoryRecord)record;
        String string3 = record.guid;
        Logger.debug(LOG_TAG, "Storing visits for " + string3 + ", replacing " + string2);
        this.dataExtender.delete(string2);
        this.dataExtender.store(string3, historyRecord.visits);
        super.update(string2, record);
    }

    @Override
    public int purgeGuid(String string2) {
        Logger.debug(LOG_TAG, "Purging record with " + string2);
        this.dataExtender.delete(string2);
        return super.purgeGuid(string2);
    }

    public void closeExtender() {
        this.dataExtender.close();
    }

    public int bulkInsert(ArrayList<HistoryRecord> arrayList) throws NullCursorException {
        if (arrayList.isEmpty()) {
            Logger.debug(LOG_TAG, "No records to insert, returning.");
        }
        int n = arrayList.size();
        ContentValues[] contentValuesArray = new ContentValues[n];
        String[] stringArray = new String[n];
        HashMap<String, Record> hashMap = new HashMap<String, Record>();
        int n2 = 0;
        for (Record record : arrayList) {
            if (record.guid == null) {
                throw new IllegalArgumentException("Record with null GUID passed in to bulkInsert.");
            }
            contentValuesArray[n2] = this.getContentValues(record);
            stringArray[n2] = record.guid;
            hashMap.put(record.guid, record);
            ++n2;
        }
        int n3 = this.context.getContentResolver().bulkInsert(this.getUri(), contentValuesArray);
        if (n3 == n) {
            Logger.debug(LOG_TAG, "Inserted " + n3 + " records, as expected.");
        } else {
            Logger.debug(LOG_TAG, "Inserted " + n3 + " records but expected " + n + " records; continuing to update visits.");
        }
        this.dataExtender.bulkInsert(arrayList);
        return n3;
    }
}

